#
# (C) Tenable Network Security
#


if (description) {
  script_id(21784);
  script_version("$Revision: 1.6 $");
  script_bugtraq_id(18737, 18738, 18739);
  script_cve_id("CVE-2006-3117", "CVE-2006-2198", "CVE-2006-2199");

  script_name(english:"OpenOffice.org < 2.0.3");
  script_summary(english:"Checks for the version of OpenOffice.org");
 
  desc = "
Synopsis :

Arbitrary code can be executed on the remote host through OpenOffice.org.

Description :

The remote host is running a version of OpenOffice.org which is older than 
version 2.0.3.

An attacker may use this to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue file to a user of the 
remote computer and have him open it. The file could be crafted in such a
way that it could exploit a buffer overflow in OpenOffice.org's XML parser,
or by containing rogue macros.

Solution : 

Upgrade to OpenOffice.org 2.0.3 or newer.

See also :

http://www.openoffice.org/security/cves/CVE-2006-2199.html
http://www.openoffice.org/security/cves/CVE-2006-2198.html
http://www.openoffice.org/security/cves/CVE-2006-3117.html

Risk factor : 

High / CVSS Base Score : 7.6
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("openoffice_installed.nasl");
  script_require_keys("SMB/OpenOffice/Build");

  exit(0);
}


build = get_kb_item("SMB/OpenOffice/Build");
if (build)
{
  matches = eregmatch(string:build, pattern:"([0-9]+[a-z][0-9]+)\(Build:([0-9]+)\)");
  if (!isnull(matches))
  {
    buildid = int(matches[2]);
    if (buildid < 9044) security_hole(get_kb_item("SMB/transport"));
  }
}
