#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25290);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-2809");
  script_bugtraq_id(24080);
  script_xref(name:"OSVDB", value:"36229");

  script_name(english:"Opera < 9.21 Buffer Overflow Vulnerability");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is prone to a buffer
overflow attack. 

Description :

The version of Opera installed on the remote host reportedly contains
a buffer overflow vulnerability that can be triggered by a malicious
Torrent file.  Successful exploitation requires that a user on the
affected host right-click on the torrent entry in the transfer manager
rather than simply click on a torrent link and may allow a remote
attacker to execute arbitrary code subject to the privileges of the
user. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=535
http://archives.neohapsis.com/archives/bugtraq/2007-05/0357.html
http://www.opera.com/support/search/view/860/

Solution :

Upgrade to Opera version 9.21 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^([0-8]\.|9\.([01][0-9]|20)($|[^0-9]))")
  security_hole(get_kb_item("SMB/transport"));
