#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25755);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-3142", "CVE-2007-3819", "CVE-2007-3929");
  script_bugtraq_id(24352, 24917, 24970);
  script_xref(name:"OSVDB", value:"38122");
  script_xref(name:"OSVDB", value:"38123");

  script_name(english:"Opera < 9.22 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is affected by multiple
issues.

Description :

The version of Opera installed on the remote host reportedly can be
tricked into attempting to dereference an invalid object pointer when
parsing a specially-crafted BitTorrent header, which could cause the
application to crash or even lead to execution of arbitrary code
subject to the privileges of the current user. 

Successful exploitation requires that a user on the affected host
click on a link to a BitTorrent file and then remove the entry from
Opera's download manager. 

In addition, it can mistakenly display the end of a 'data:' URL rather
than the beginning, which can lead to spoofing of trusted sites. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=564
http://archives.neohapsis.com/archives/fulldisclosure/2007-07/0406.html
http://www.securityfocus.com/archive/1/473703/30/0/threaded
http://www.0x000000.com/?i=334
http://www.opera.com/support/search/view/862/
http://www.opera.com/support/search/view/863/
http://www.opera.com/support/search/view/864/
http://www.opera.com/docs/changelogs/windows/922/

Solution :

Upgrade to Opera version 9.22 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^([0-8]\.|9\.([01][0-9]|2[01])($|[^0-9]))")
  security_hole(get_kb_item("SMB/transport"));
