#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25900);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-4367");
  script_bugtraq_id(25331);
  script_xref(name:"OSVDB", value:"38124");
  script_xref(name:"OSVDB", value:"38125");

  script_name(english:"Opera < 9.23 Arbitrary Code Execution Vulnerability");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is affected by an
arbitrary code execution vulnerability. 

Description :

The version of Opera installed on the remote host reportedly allows
for execution of arbitrary code via specially-crafted Javascript if a
user can be tricked into visiting a malicious site. 

See also :

http://www.opera.com/support/search/view/865/
http://www.opera.com/docs/changelogs/windows/923/

Solution :

Upgrade to Opera version 9.23 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^([0-8]\.|9\.([01][0-9]|2[0-2])($|[^0-9]))")
  security_hole(get_kb_item("SMB/transport"));
