#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31129);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-1080", "CVE-2008-1081", "CVE-2008-1082");
  script_bugtraq_id(27901);
  script_xref(name:"Secunia", value:"29029");

  script_name(english:"Opera < 9.26 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Opera");

  desc = "
Synopsis :

The remote host contains a web browser that is affected by several
issues. 

Description :

The version of Opera installed on the remote host reportedly is
affected by several issues :

  - Simulated text input could trick users into 
    uploading arbitrary files.

  - Image properties comments containing script will
    be run when displaying the image properties, 
    leading to code execution in the wrong security 
    context.

  - Representation of DOM attribute values could allow
    cross-site scripting when importing XML into a 
    document.

See also :

http://www.opera.com/support/search/view/877/
http://www.opera.com/support/search/view/879/
http://www.opera.com/support/search/view/880/
http://www.opera.com/docs/changelogs/windows/926/

Solution :

Upgrade to Opera version 9.26 or later. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("opera_installed.nasl");
  script_require_keys("SMB/Opera/Version");

  exit(0);
}


ver = get_kb_item("SMB/Opera/Version");
if (ver && ver =~ "^([0-8]\.|9\.([01][0-9]|2[0-5])($|[^0-9]))")
  security_warning(get_kb_item("SMB/transport"));
