#
# (C) Tenable Network Security
#


 desc["english"] = "
Synopsis :

The remote host contains a web browser which is affected by multiple
issues. 

Description :

The remote host is using Opera, an alternative web browser. 

The version of Opera installed on the remote host is affected by
several issues.  One may allow an attacker to drop arbitrary files
with arbitrary names on this host; another may allow an attacker to
traverse directories on the affected host. 

To exploit these flaws, an attacker would need to set up a rogue
website and lure a user of this host visit it using Opera.  He might
then be able to execute arbitrary code on this host. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2003-11/0119.html
http://archives.neohapsis.com/archives/bugtraq/2003-11/0121.html
http://www.opera.com/docs/changelogs/windows/722/

Solution : 

Upgrade to Opera version 7.22 or later.

Risk factor :

High / CVSS Base Score : 8 
(AV:R/AC:H/Au:NR/C:C/I:C/A:C/B:N)";


if(description)
{
 script_id(11922);
 script_version("$Revision: 1.7 $");

 script_bugtraq_id(9019, 9021);
 script_xref(name:"OSVDB", value:"2806");

 name["english"] = "Opera < 7.23 Multiple Vulnerabilities";

 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Opera.exe";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("opera_installed.nasl");
 script_require_keys("SMB/Opera/Version");
 exit(0);
}




v = get_kb_item("SMB/Opera/Version");
if(strlen(v))
{
  v2 = split(v, sep:'.', keep:FALSE);
  if(int(v2[0]) < 7 || (int(v2[0]) == 7 && int(v2[1]) < 22))
  {
    report = string(
      desc["english"],
      "\n\n",
      "Plugin output :\n",
      "\n",
      "We have determined that you are running Opera ", v, "."
    );
    security_hole(port:get_kb_item("SMB/transport"), data:report);
  }
}
