#
# (C) Tenable Network Security, Inc.
#
# SinFP is a fingerprinting tool written by GomoR and available
# at http://www.gomor.org/cgi-bin/sinfp.pl
#
# This plugin is a white-room reimplementation of the SinFP methodology 
#
ENGINE_VERSION = 7;

if (description)
{
  script_id(25250);
  script_version("$Revision: 1.40 $");

  name["english"] = "OS Identification : SinFP";
  script_name(english:name["english"]);

  desc["english"] = "
This script attempts to identify the Operating System type and 
version by using the same technique as SinFP

See also : http://www.gomor.org/cgi-bin/sinfp.pl
Risk factor : None";

  script_description(english:desc["english"]);
 
  summary["english"] = "Determines the remote operating system";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2007 - 2008 Tenable Network Security");
  family["english"] = "General";
  script_family(english:family["english"]);
  exit(0);
}

if ( ! defined_func("bsd_byte_ordering") ) exit(0);
if ( TARGET_IS_IPV6 ) exit(0);
if (  islocalhost() ) exit(0);


include("raw.inc");

signatures[0] = "
3Com SuperStack Switch:switch:B11013:F0x12:W1024:O0204ffff:M1432:B11013:F0x12:W1024:O0204ffff:M1432:B11023:F0x1c:W0:O0:M0
3Com SuperStack Switch:switch:B11013:F0x12:W8192:O0204ffff:M1460:B11013:F0x12:W8192:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
AIX 4.3.2:general-purpose:B11013:F0x12:W16384:O0204ffff:M512:B11013:F0x12:W16384:O0204ffff:M512:B11020:F0x04:W16384:O0:M0
AIX 5.1:general-purpose:B11113:F0x12:W60032:O0204ffff:M1380:B11113:F0x12:W60720:O0204ffff:M1380:B02023:F0x14:W5840:O0:M0
AIX 5.2:general-purpose:B11013:F0x12:W16384:O0204ffff:M1460:B11013:F0x12:W17520:O0204ffff:M1460:B11020:F0x04:W16384:O0:M0
AIX 5.3:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
AIX 5.3:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65160:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
Alcatel VoIP terminal:embedded:B11013:F0x12:W16000:O0204ffff:M1456:B11013:F0x12:W16000:O0204ffff:M1456:B11013:F0x12:W16000:O0204ffff:M1456
Alteon:switch:B11013:F0x12:W16384:O0204ffff:M536:B11013:F0x12:W16384:O0204ffff:M536:B11020:F0x04:W0:O0:M0
Alteon:switch:B12113:F0x12:W5840:O00000000:M0:B12113:F0x12:W5840:O0204ffff:M1460:B00000:F0:W0:O0:M0
Apple Airport:wireless-access-point:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
BEFW11S4:router:B10013:F0x12:W5840:O0204ffff:M1460:B12003:F0x14:W5840:O0:M0:B12023:F0x14:W5840:O0:M0
CISCO IOS 11.0:router:B10013:F0x12:W2144:O0204ffff:M536:B10013:F0x12:W2144:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CISCO IOS 11.1:router:B10013:F0x12:W2144:O0204ffff:M536:B10013:F0x12:W2144:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CISCO IOS 11.2:router:B10013:F0x12:W4288:O0204ffff:M536:B10013:F0x12:W4288:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CISCO IOS 11.3:router:B10013:F0x12:W4128:O0204ffff:M556:B10013:F0x12:W4128:O0204ffff:M556:B11020:F0x04:W0:O0:M0
CISCO IOS 12.0:router:B10013:F0x12:W4128:O0204ffff:M1460:B10013:F0x12:W4128:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
CISCO IOS 12.0:router:B10013:F0x12:W4128:O0204ffff:M556:B10013:F0x12:W4128:O0204ffff:M556:B11020:F0x04:W0:O0:M0
CISCO IOS 12.1:router:B10013:F0x12:W4128:O0204ffff:M536:B10013:F0x12:W4128:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CISCO IOS 12.2:router:B10013:F0x12:W4128:O0204ffff:M536:B10013:F0x12:W4128:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CISCO IOS 12.3:router:B10013:F0x12:W4128:O0204ffff:M536:B10013:F0x12:W4128:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CISCO IOS 12.4:router:B11013:F0x12:W4128:O0204ffff:M536:B11013:F0x12:W4128:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
CISCO PIX 6.3:firewall:B11013:F0x12:W4096:O0204ffff:M1460:B11013:F0x12:W4096:O0204ffff:M1460:B11013:F0x12:W4096:O0204ffff:M1460
CISCO PIX 7.0:firewall:B11013:F0x12:W64240:O0204ffff:M1460:B11013:F0x12:W64240:O0204ffff:M1460:B11020:F0x04:W32767:O0:M0
Canon imageRunner Printer:printer:B11013:F0x12:W16384:O0204ffff:M1460:B11013:F0x12:W16384:O0204ffff:M1460:B11020:F0x04:W16384:O0:M0
CatalystOS 1900:switch:B11013:F0x12:W1024:O0204ffff:M536:B11013:F0x12:W1024:O0204ffff:M536:B11020:F0x04:W0:O0:M0
CatalystOS 6.3:switch:B11013:F0x12:W4096:O0204ffff:M1460:B11013:F0x12:W4096:O0204ffff:M1460:B11020:F0x04:W4096:O0:M0
Digital UNIX 4.0:general-purpose:B11113:F0x12:W32768:O0204ffff:M1460:B11113:F0x12:W33580:O0204ffff01030300:M1460:B11020:F0x04:W32768:O0:M0
Digital UNIX 4.0:general-purpsoe:B11113:F0x12:W33396:O0204ffff:M1460:B11113:F0x12:W33396:O0204ffff01030300:M1460:B11020:F0x04:W32768:O0:M0
EthernetBoard OkiLAN 8100e:switch:B11013:F0x12:W3072:O0204ffff01030300:M1460:B11013:F0x12:W3072:O0204ffff01030300:M1460:B11023:F0x14:W3072:O0:M0
Fortigate:firewall:B11113:F0x12:W5840:O0204ffff:M1460:B11113:F0x12:W5792:O010303000402080affffffff444541440204ffff:M1460:B00000:F0:W0:O0:M0
FreeBSD 3.4:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17520:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 3.5:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17520:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.10:general-purpose:B11113:F0x12:W57344:O0204ffff:M1460:B11113:F0x12:W57344:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.11:general-purpose:B11113:F0x12:W57344:O0204ffff:M1460:B11113:F0x12:W57344:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.2:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17520:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.3:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17520:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.4:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17376:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.7:general-purpose:B11113:F0x12:W57344:O0204ffff:M1460:B11113:F0x12:W57344:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.8:general-purpose:B11113:F0x12:W57344:O0204ffff:M1460:B11113:F0x12:W57344:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 4.9:general-purpose:B11113:F0x12:W57344:O0204ffff:M1460:B11113:F0x12:W57344:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 5.1:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
FreeBSD 5.2:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 5.3:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414401010402:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 5.4:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414401010402:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 5.5:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414401010402:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 6.0:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414404020000:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 6.1:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414404020000:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 6.2:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414404020000:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 6.3:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303010101080affffffff4445414404020000:M1460:B11120:F0x04:W0:O0:M0
FreeBSD 7.0:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303030402080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
GoogleOS:embedded:B11013:F0x12:W8190:O0204ffff:M1452:B11013:F0x12:W8190:O0204ffff:M1452:B11023:F0x04:W8201:O0:M0
GoogleOS:embedded:B11013:F0x12:W8190:O0204ffff:M536:B11013:F0x12:W8190:O0204ffff:M1440:B01023:F0x04:W8201:O0:M0
HP JetDirect Printer:printer:B11013:F0x12:W8192:O0204ffff:M1460:B11013:F0x12:W8192:O0204ffff01030300:M1460:B11020:F0x04:W8192:O0:M0
HP ProCurve Switch:switch:B11013:F0x12:W8192:O0204ffff:M1460:B11013:F0x12:W8192:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W8192:O0:M0
HP-UX 10.20:general-purpose:B11113:F0x12:W32768:O0204ffff:M1460:B11113:F0x12:W32768:O0204ffff:M1460:B11020:F0x04:W32768:O0:M0
HP-UX 11.00:general-purpose:B11113:F0x12:W32768:O0204ffff:M536:B11113:F0x12:W32768:O0204ffff01010402030300010101080affffffff44454144:M1460:B11120:F0x04:W0:O4e6f20544350:M0
HP-UX 11.01:general-purpose:B11103:F0x12:W32768:O0204ffff:M1460:B11113:F0x12:W32768:O0204ffff:M1460:B11020:F0x04:W32768:O0:M0
HP-UX 11.11:general-purpose:B11113:F0x12:W32768:O0204ffff:M536:B11113:F0x12:W32768:O0204ffff01010402030300010101080affffffff44454144:M1460:B11120:F0x04:W0:O4e6f20544350:M0
HP-UX 11.23:general-purpose:B11113:F0x12:W32768:O0204ffff:M536:B11113:F0x12:W32768:O0204ffff01010402030300010101080affffffff44454144:M1460:B11120:F0x04:W0:O4e6f20544350:M0
HP-UX 9.05:general-purpose:B11013:F0x12:W8192:O0204ffff:M1460:B11013:F0x12:W8192:O0204ffff:M1460:B00000:F0:W0:O0:M0
IRIX 6.5:general-purpose:B11113:F0x12:W49152:O0204ffff01010402:M1460:B11113:F0x12:W49152:O0204ffff010303000101080affffffff4445414401010402:M1460:B11020:F0x04:W0:O0:M0
KYOCERA Printer:printer:B11013:F0x12:W256:O0204ffff:M1460:B11013:F0x12:W256:O0204ffff:M1460:B11023:F0x14:W256:O0:M0
LaserWriter Printer:printer:B11113:F0x12:W4380:O0204ffff:M536:B11113:F0x12:W4380:O0204ffff:M536:B00000:F0:W0:O0:M0
Linux Kernel 2.0:general-purpose:B11013:F0x12:W32736:O0204ffff:M536:B11013:F0x12:W32736:O0204ffff:M1460:B01020:F0x04:W0:O0:M0
Linux Kernel 2.2:general-purpose:B11113:F0x12:W32696:O0204ffff:M536:B11113:F0x12:W32120:O0204ffff0402080affffffff4445414401030300:M1460:B01020:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030300:M1460:B00120:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030300:M1460:B10120:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B11113:F0x12:W5840:O0204ffff:M1460:B11113:F0x12:W5792:O0204ffff0402080affffffff4445414401030300:M1460:B11120:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030300:M1460:B11120:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030302:M1460:B10120:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030305:M1460:B00000:F0:W0:O0:M0
Linux Kernel 2.6:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030305:M1460:B10120:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030306:M1460:B10120:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B10113:F0x12:W5840:O0204ffff:M1460:B10113:F0x12:W5792:O0204ffff0402080affffffff4445414401030307:M1460:B11120:F0x04:W0:O0:M0
Mac OS X 10.3:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
Mac OS X 10.4:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
Mac OS X 10.5:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303000101080affffffff4445414404020000:M1460:B11020:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B11013:F0x12:W16384:O0204ffff:M1460:B11013:F0x12:W16384:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B11113:F0x12:W16616:O0204ffff:M1460:B11113:F0x12:W17520:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B11113:F0x12:W64240:O0204ffff:M1460:B11113:F0x12:W64240:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows 98:general-purpose:B11113:F0x12:W8576:O0204ffff:M1460:B11113:F0x12:W8760:O0204ffff01010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows NT 4.0:general-purpose:B11113:F0x12:W8576:O0204ffff:M1460:B11113:F0x12:W8760:O0204ffff:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows Server 2003:general-purpose:B11013:F0x12:W16384:O0204ffff:M1460:B11013:F0x12:W16384:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows Server 2003:general-purpose:B11013:F0x12:W64240:O0204ffff:M1460:B11013:F0x12:W64240:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows Server 2008:general-purpose:B11113:F0x12:W8192:O0204ffff:M1460:B11113:F0x12:W8192:O0204ffff010303080402080affffffff44454144:M1460:B11121:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B11113:F0x12:W8192:O0204ffff:M1460:B11113:F0x12:W8192:O0204ffff010303080402080affffffff44454144:M1460:B11121:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B11113:F0x12:W8192:O0204ffff:M1460:B11113:F0x12:W8192:O0204ffff010303080402080affffffff44454144:M1460:B11121:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B11113:F0x12:W8192:O0204ffff:M1460:B11113:F0x12:W8192:O0204ffff030308010402080affffffff44454144:M1460:B11121:F0x04:W0:O0:M0
Microsoft Windows XP:general-purpose:B11113:F0x12:W16616:O0204ffff:M1460:B11113:F0x12:W17520:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
Microsoft Windows XP:general-purpose:B11113:F0x12:W65535:O0204ffff:M1460:B11113:F0x12:W65535:O0204ffff010303000101080a000000000000000001010402:M1460:B11021:F0x04:W0:O0:M0
NetBSD 1.6:general-purpose:B11013:F0x12:W16384:O0204ffff:M1460:B11013:F0x12:W16384:O0204ffff010303000101080a0000000044454144:M1460:B11020:F0x04:W0:O0:M0
NetBSD 3.0:general-purpose:B11113:F0x12:W32768:O0204ffff:M1460:B11113:F0x12:W32768:O0204ffff010303000101080a000000004445414404020101:M1460:B11020:F0x04:W0:O0:M0
Nortel Switch:switch:B11013:F0x12:W1024:O0204ffff:M1480:B11013:F0x12:W1024:O0204ffff0101080affffffff4445414401030301:M1460:B11023:F0x14:W0:O0:M0
Nortel Switch:switch:B11013:F0x12:W16384:O0204ffff:M536:B11013:F0x12:W16384:O0204ffff:M536:B11020:F0x04:W0:O0:M0
Nortel Switch:switch:B11013:F0x12:W8760:O0204ffff:M536:B11013:F0x12:W8760:O0204ffff:M536:B11020:F0x04:W0:O0:M0
Novell NetWare 5.1:general-purpose:B11113:F0x12:W6144:O0204ffff:M1460:B11113:F0x12:W6144:O0204ffff0303000104020101:M1460:B11120:F0x04:W0:O0:M0
OpenBSD 3.1:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17376:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W16384:O0:M0
OpenBSD 3.2:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17376:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W16384:O0:M0
OpenBSD 3.3:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W17376:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W16384:O0:M0
OpenBSD 3.4:general-purpose:B11113:F0x12:W17520:O0204ffff:M1460:B11113:F0x12:W17376:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W16384:O0:M0
OpenBSD 3.5:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
OpenBSD 3.6:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
OpenBSD 3.7:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
OpenBSD 3.8:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
OpenBSD 3.9:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
OpenBSD 4.0:general-purpose:B11113:F0x12:W16384:O0204ffff:M1460:B11113:F0x12:W16384:O0204ffff01010402010303000101080affffffff44454144:M1460:B11120:F0x04:W0:O0:M0
OpenVMS 7.2:general-purpose:B11013:F0x12:W4356:O0204ffff:M1460:B11013:F0x12:W4356:O0204ffff01030300:M1460:B11020:F0x04:W3000:O0:M0
PacketShaper:router:B11013:F0x12:W1460:O0204ffff:M1460:B11013:F0x12:W1460:O0204ffff:M1460:B11020:F0x04:W4096:O0:M0
RICOH Printer:printer:B11013:F0x12:W16384:O0204ffff:M1460:B11013:F0x12:W16384:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W0:O0:M0
SCO OpenServer 5.0.7:general-purpose:B11013:F0x12:W33580:O0204ffff:M1460:B11013:F0x12:W33580:O0204ffff:M1460:B11020:F0x04:W0:O0:M0
SCO OpenServer 5.0:general-purpose:B11113:F0x12:W24820:O0204ffff:M1460:B11113:F0x12:W24820:O0204ffff:M1460:B11120:F0x04:W0:O0:M0
SCO UnixWare 2.1.1:general-purpose:B11013:F0x12:W512:O0204ffff:M512:B11013:F0x12:W512:O0204ffff:M512:B00000:F0:W0:O0:M0
SCO UnixWare 7.1.1:general-purpose:B11113:F0x12:W24820:O0204ffff:M1460:B11113:F0x12:W24820:O0204ffff010303000101080affffffff44454144:M1460:B11120:F0x04:W4096:O0:M0
SideWinder Firewall:firewall:B11113:F0x12:W32768:O0204ffff:M1380:B11113:F0x12:W32768:O0204ffff010303000101080affffffff4445414404020000:M1460:B02022:F0x14:W5840:O0:M0
SonicOS 3.1:firewall:B11013:F0x12:W16384:O0204ffff:M512:B11013:F0x12:W16384:O0204ffff010303000101080affffffff44454144:M512:B00020:F0x04:W5840:O65686e63:M0
Sun Solaris 10:general-purpose:B11113:F0x12:W49312:O0204ffff:M1460:B11113:F0x12:W49232:O0101080affffffff444541440204ffff0103030001010402:M1460:B01120:F0x04:W0:O0:M0
Sun Solaris 2.5:general-purpose:B11113:F0x12:W9112:O0204ffff:M536:B11113:F0x12:W8760:O0204ffff:M1460:B01120:F0x04:W0:O0:M0
Sun Solaris 2.6:general-purpose:B11113:F0x12:W9112:O0204ffff:M536:B11113:F0x12:W10136:O0101080affffffff44454144010303000204ffff:M1460:B01120:F0x04:W0:O0:M0
Sun Solaris 7:general-purpose:B11113:F0x12:W9112:O0204ffff:M536:B11113:F0x12:W10136:O0101080affffffff4445414401030300010104020204ffff:M1460:B01120:F0x04:W0:O0:M0
Sun Solaris 8:general-purpose:B11113:F0x12:W24656:O0204ffff:M1460:B11113:F0x12:W24616:O0101080affffffff4445414401030300010104020204ffff:M1460:B11120:F0x04:W0:O0:M0
Sun Solaris 9:general-purpose:B11113:F0x12:W49312:O0204ffff:M1460:B11113:F0x12:W49232:O0101080affffffff444541440204ffff0103030001010402:M1460:B01120:F0x04:W0:O0:M0
Tru64 Unix version 5.0A:general-purpose:B11013:F0x12:W33396:O0204ffff:M1460:B11013:F0x12:W33396:O0204ffff01030300:M1460:B11020:F0x04:W32768:O0:M0
Tru64 Unix version 5.1:general-purpose:B11013:F0x12:W61440:O0204ffff:M1460:B11013:F0x12:W61440:O0204ffff01030300:M1460:B11020:F0x04:W61440:O0:M0
Tru64 Unix version 5.1A:general-purpose:B11013:F0x12:W61440:O0204ffff:M1460:B11013:F0x12:W61440:O0204ffff01030300:M1460:B11020:F0x04:W61440:O0:M0
VAX/VMS 7.1:general-purpose:B11013:F0x12:W3000:O0204ffff:M1460:B11013:F0x12:W3000:O0204ffff:M1460:B11020:F0x04:W3000:O0:M0
VxWorks:embedded:B11113:F0x12:W8192:O0204ffff:M1460:B11113:F0x12:W8192:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W8192:O0:M0
VxWorks:embedded:B11013:F0x12:W8192:O0204ffff:M1460:B11013:F0x12:W8192:O0204ffff010303000101080affffffff44454144:M1460:B11020:F0x04:W8192:O0:M0
VxWorks:embedded:B11013:F0x12:W8192:O0204ffff:M512:B11013:F0x12:W8192:O0204ffff01030300:M512:B11020:F0x04:W8192:O0:M0
";

signatures[1] = "
AIX 4.3.2:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M[45]..:B...13:F0x12:W1[567]...:O0204ffff:M[45]..:B...20:F0x04:W1[567]...:O0:M0
AIX 5.2:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff:M1[34]..:B...20:F0x04:W1[567]...:O0:M0
AIX 5.3:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
Alteon Load Balancer:load-balancer:B...13:F0x12:W1[567]...:O0204ffff:M536:B...13:F0x12:W1[567]...:O0204ffff:M536:B...20:F0x04:W0:O0:M0
Alteon Load Balancer:load-balancer:B...13:F0x12:W5[789]..:O00000000:M0:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B00000:F0:W0:O0:M0
BEFW11S4:router:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...03:F0x14:W5[789]..:O0:M0:B...23:F0x14:W5[789]..:O0:M0
CISCO IOS 11.0:router:B...13:F0x12:W2[012]..:O0204ffff:M536:B...13:F0x12:W2[012]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
CISCO IOS 11.1:router:B...13:F0x12:W2[012]..:O0204ffff:M536:B...13:F0x12:W2[012]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
CISCO IOS 11.2:router:B...13:F0x12:W4[123]..:O0204ffff:M536:B...13:F0x12:W4[123]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
CISCO IOS 11.3:router:B...13:F0x12:W4[012]..:O0204ffff:M[456]..:B...13:F0x12:W4[012]..:O0204ffff:M[456]..:B...20:F0x04:W0:O0:M0
CISCO IOS 12.0:router:B...13:F0x12:W4[012]..:O0204ffff:M1[34]..:B...13:F0x12:W4[012]..:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
CISCO IOS 12.0:router:B...13:F0x12:W4[012]..:O0204ffff:M[456]..:B...13:F0x12:W4[012]..:O0204ffff:M[456]..:B...20:F0x04:W0:O0:M0
CISCO IOS 12.1:router:B...13:F0x12:W4[012]..:O0204ffff:M536:B...13:F0x12:W4[012]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
CISCO IOS 12.2:router:B...13:F0x12:W4[012]..:O0204ffff:M536:B...13:F0x12:W4[012]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
CISCO IOS 12.3:router:B...13:F0x12:W4[012]..:O0204ffff:M536:B...13:F0x12:W4[012]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
CISCO IOS 12.4:router:B...13:F0x12:W4[012]..:O0204ffff:M536:B...13:F0x12:W4[012]..:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
CISCO PIX 6.3:firewall:B...13:F0x12:W((39..)|(4[01]..)):O0204ffff:M1[34]..:B...13:F0x12:W((39..)|(4[01]..)):O0204ffff:M1[34]..:B...13:F0x12:W((39..)|(4[01]..)):O0204ffff:M1[34]..
CISCO PIX 7.0:router:B...13:F0x12:W6[345]...:O0204ffff:M1[34]..:B...13:F0x12:W6[345]...:O0204ffff:M1[34]..:B...20:F0x04:W3[123]...:O0:M0
CatalystOS 1900:switch:B...13:F0x12:W((9..)|(10..)):O0204ffff:M536:B...13:F0x12:W((9..)|(10..)):O0204ffff:M536:B...20:F0x04:W0:O0:M0
CatalystOS 6.3:switch:B...13:F0x12:W((39..)|(4[01]..)):O0204ffff:M1[34]..:B...13:F0x12:W((39..)|(4[01]..)):O0204ffff:M1[34]..:B...20:F0x04:W((39..)|(4[01]..)):O0:M0
Digital UNIX 4.0:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M1[34]..:B...13:F0x12:W3[234]...:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W3[123]...:O0:M0
Digital UNIX 4.0:general-purpose:B...13:F0x12:W3[234]...:O0204ffff:M1[34]..:B...13:F0x12:W3[234]...:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W3[123]...:O0:M0
EthernetBoard OkiLAN 8100e:switch:B...13:F0x12:W((29..)|(3[12]..)):O0204ffff(01)?(030300)?:M1[34]..:B...13:F0x12:W((29..)|(3[12]..)):O0204ffff(01)?(030300)?:M1[34]..:B...23:F0x14:W((29..)|(3[12]..)):O0:M0
Fortigate:firewall:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O(01)?(030300)?(0402)?(080affffffff44454144)?0204ffff:M1[34]..:B00000:F0:W0:O0:M0
FreeBSD 3.4:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 3.5:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.10:general-purpose:B...13:F0x12:W5[678]...:O0204ffff:M1[34]..:B...13:F0x12:W5[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.11:general-purpose:B...13:F0x12:W5[678]...:O0204ffff:M1[34]..:B...13:F0x12:W5[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.2:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.3:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.4:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.7:general-purpose:B...13:F0x12:W5[678]...:O0204ffff:M1[34]..:B...13:F0x12:W5[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.8:general-purpose:B...13:F0x12:W5[678]...:O0204ffff:M1[34]..:B...13:F0x12:W5[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 4.9:general-purpose:B...13:F0x12:W5[678]...:O0204ffff:M1[34]..:B...13:F0x12:W5[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 5.1:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 5.2:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 5.3:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 5.4:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 5.5:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 6.0:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?(0402)?(0000)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 6.1:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?(0402)?(0000)?:M1[34]..:B...20:F0x04:W0:O0:M0
FreeBSD 6.2:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030301)?(01)?(01)?(080affffffff44454144)?(0402)?(0000)?:M1[34]..:B...20:F0x04:W0:O0:M0
GoogleOS:embedded:B...13:F0x12:W8[123]..:O0204ffff:M1[345]..:B...13:F0x12:W8[123]..:O0204ffff:M1[345]..:B...23:F0x04:W8[123]..:O0:M0
GoogleOS:embedded:B...13:F0x12:W8[123]..:O0204ffff:M536:B...13:F0x12:W8[123]..:O0204ffff:M1[34]..:B...23:F0x04:W8[123]..:O0:M0
HP JetDirect Printer:printer:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B...13:F0x12:W8[012]..:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W8[012]..:O0:M0
HP JetDirect Printer:printer:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B...13:F0x12:W8[012]..:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W8[012]..:O0:M0
HP-UX 10.20:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M1[34]..:B...13:F0x12:W3[123]...:O0204ffff:M1[34]..:B...20:F0x04:W3[123]...:O0:M0
HP-UX 11.00:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M536:B...13:F0x12:W3[123]...:O0204ffff(01)?(01)?(0402)?(030300)?(01)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O4e6f20544350:M0
HP-UX 11.01:general-purpose:B...03:F0x12:W3[123]...:O0204ffff:M1[34]..:B...13:F0x12:W3[123]...:O0204ffff:M1[34]..:B...20:F0x04:W3[123]...:O0:M0
HP-UX 11.11:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M536:B...13:F0x12:W3[123]...:O0204ffff(01)?(01)?(0402)?(030300)?(01)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O4e6f20544350:M0
HP-UX 11.23:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M536:B...13:F0x12:W3[123]...:O0204ffff(01)?(01)?(0402)?(030300)?(01)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O4e6f20544350:M0
HP-UX 9.05:general-purpose:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B00000:F0:W0:O0:M0
IRIX 6.5:general-purpose:B...13:F0x12:W((4[89]...)|(50...)):O0204ffff(01)?(01)?(0402)?:M1[34]..:B...13:F0x12:W((4[89]...)|(50...)):O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M1[34]..:B...20:F0x04:W0:O0:M0
KYOCERA Printer:printer:B...13:F0x12:W2[456].:O0204ffff:M1[34]..:B...13:F0x12:W2[456].:O0204ffff:M1[34]..:B...23:F0x14:W2[456].:O0:M0
LaserWriter Printer:printer:B...13:F0x12:W4[234]..:O0204ffff:M536:B...13:F0x12:W4[234]..:O0204ffff:M536:B00000:F0:W0:O0:M0
Linux Kernel 2.4:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030300)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030300)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030302)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.0:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M536:B...13:F0x12:W3[123]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.2:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M536:B...13:F0x12:W3[123]...:O0204ffff(0402)?(080affffffff44454144)?(01)?(030300)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030300)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030300)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030305)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030305)?:M1[34]..:B00000:F0:W0:O0:M0
Linux Kernel 2.6:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030306)?:M1[34]..:B...20:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B...13:F0x12:W5[789]..:O0204ffff:M1[34]..:B...13:F0x12:W5[678]..:O0204ffff(0402)?(080affffffff44454144)?(01)?(030307)?:M1[34]..:B...20:F0x04:W0:O0:M0
Mac OS X 10.4:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?(0402)?(00)?(00)?:M1[34]..:B...20:F0x04:W0:O0:M0
Mac OS X 10.4:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?(0402)?(00)?(00)?:M1[34]..:B...20:F0x04:W0:O0:M0
Mac OS X 10.4:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B...13:F0x12:W6[345]...:O0204ffff:M1[34]..:B...13:F0x12:W6[345]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows 98:general-purpose:B...13:F0x12:W8[456]..:O0204ffff:M1[34]..:B...13:F0x12:W8[678]..:O0204ffff(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows NT 4.0:general-purpose:B...13:F0x12:W8[456]..:O0204ffff:M1[34]..:B...13:F0x12:W8[678]..:O0204ffff:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows Server 2003:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B...13:F0x12:W8[012]..:O0204ffff(01)?(030308)?(0402)?(080affffffff44454144)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B...13:F0x12:W8[012]..:O0204ffff(01)?(030308)?(0402)?(080affffffff44454144)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B...13:F0x12:W8[012]..:O0204ffff:M1[34]..:B...13:F0x12:W8[012]..:O0204ffff(030308)?(01)?(0402)?(080affffffff44454144)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows XP:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[678]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
Microsoft Windows XP:general-purpose:B...13:F0x12:W6[45]...:O0204ffff:M1[34]..:B...13:F0x12:W6[45]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M1[34]..:B...21:F0x04:W0:O0:M0
NetBSD 1.6:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000044454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
NetBSD 3.0:general-purpose:B...13:F0x12:W3[123]...:O0204ffff:M1[34]..:B...13:F0x12:W3[123]...:O0204ffff(01)?(030300)?(01)?(01)?(080a0000000044454144)?(0402)?(01)?(01)?:M1[34]..:B...20:F0x04:W0:O0:M0
NetWare 5.1:NetWare:B...13:F0x12:W6[012]..:O0204ffff:M1[34]..:B...13:F0x12:W6[012]..:O0204ffff(030300)?(01)?(0402)?(01)?(01)?:M1[34]..:B...20:F0x04:W0:O0:M0
Nortel Switch:switch:B...13:F0x12:W1[567]...:O0204ffff:M536:B...13:F0x12:W1[567]...:O0204ffff:M536:B...20:F0x04:W0:O0:M0
Nortel Switch:switch:B...13:F0x12:W8[678]..:O0204ffff:M536:B...13:F0x12:W8[678]..:O0204ffff:M536:B...20:F0x04:W0:O0:M0
Nortel unknown:Switch:B...13:F0x12:W((9..)|(10..)):O0204ffff:M1[345]..:B...13:F0x12:W((9..)|(10..)):O0204ffff(01)?(01)?(080affffffff44454144)?(01)?(030301)?:M1[34]..:B...23:F0x14:W0:O0:M0
OpenBSD 3.1:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W1[567]...:O0:M0
OpenBSD 3.2:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W1[567]...:O0:M0
OpenBSD 3.3:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W1[567]...:O0:M0
OpenBSD 3.4:general-purpose:B...13:F0x12:W1[678]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W1[567]...:O0:M0
OpenBSD 3.5:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
OpenBSD 3.6:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
OpenBSD 3.7:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
OpenBSD 3.8:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
OpenBSD 3.9:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
OpenBSD 4.0:general-purpose:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(01)?(0402)?(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
OpenVMS 7.2:general-purpose:B...13:F0x12:W4[234]..:O0204ffff:M1[34]..:B...13:F0x12:W4[234]..:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W((29..)|(3[01]..)):O0:M0
PacketShaper unknown:router:B...13:F0x12:W1[345]..:O0204ffff:M1[34]..:B...13:F0x12:W1[345]..:O0204ffff:M1[34]..:B...20:F0x04:W((39..)|(4[01]..)):O0:M0
RICOH Printer:printer:B...13:F0x12:W1[567]...:O0204ffff:M1[34]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W0:O0:M0
SCO OpenServer 5.0:general-purpose:B...13:F0x12:W2[345]...:O0204ffff:M1[34]..:B...13:F0x12:W2[345]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
SCO OpenServer 5.0.7:general-purpose:B...13:F0x12:W3[234]...:O0204ffff:M1[34]..:B...13:F0x12:W3[234]...:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
SCO UnixWare 2.1.1:general-purpose:B...13:F0x12:W5[012].:O0204ffff:M[45]..:B...13:F0x12:W5[012].:O0204ffff:M[45]..:B00000:F0:W0:O0:M0
SCO UnixWare 7.1.1:general-purpose:B...13:F0x12:W2[345]...:O0204ffff:M1[34]..:B...13:F0x12:W2[345]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M1[34]..:B...20:F0x04:W((39..)|(4[01]..)):O0:M0
SonicOS 3.1:firewall:B...13:F0x12:W1[567]...:O0204ffff:M[45]..:B...13:F0x12:W1[567]...:O0204ffff(01)?(030300)?(01)?(01)?(080affffffff44454144)?:M[45]..:B...20:F0x04:W5[789]..:O65686e63:M0
Sun Solaris 10:general-purpose:B...13:F0x12:W((4[89]...)|(50...)):O0204ffff:M1[34]..:B...13:F0x12:W((4[89]...)|(50...)):O(01)?(01)?(080affffffff44454144)?0204ffff(01)?(030300)?(01)?(01)?(0402)?:M1[34]..:B...20:F0x04:W0:O0:M0
Sun Solaris 2.5:general-purpose:B...13:F0x12:W9[012]..:O0204ffff:M536:B...13:F0x12:W8[678]..:O0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
Sun Solaris 2.6:general-purpose:B...13:F0x12:W9[012]..:O0204ffff:M536:B...13:F0x12:W10[012]..:O(01)?(01)?(080affffffff44454144)?(01)?(030300)?0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
Sun Solaris 7:general-purpose:B...13:F0x12:W9[012]..:O0204ffff:M536:B...13:F0x12:W10[012]..:O(01)?(01)?(080affffffff44454144)?(01)?(030300)?(01)?(01)?(0402)?0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
Sun Solaris 8:general-purpose:B...13:F0x12:W2[345]...:O0204ffff:M1[34]..:B...13:F0x12:W2[345]...:O(01)?(01)?(080affffffff44454144)?(01)?(030300)?(01)?(01)?(0402)?0204ffff:M1[34]..:B...20:F0x04:W0:O0:M0
Sun Solaris 9:general-purpose:B...13:F0x12:W((4[89]...)|(50...)):O0204ffff:M1[34]..:B...13:F0x12:W((4[89]...)|(50...)):O(01)?(01)?(080affffffff44454144)?0204ffff(01)?(030300)?(01)?(01)?(0402)?:M1[34]..:B...20:F0x04:W0:O0:M0
Superstack II switch:switch:B...13:F0x12:W((9..)|(10..)):O0204ffff:M536:B...13:F0x12:W((9..)|(10..)):O0204ffff:M536:B...23:F0x1c:W0:O0:M0
Tru64 Unix 5.0A:general-purpose:B...13:F0x12:W3[234]...:O0204ffff:M1[34]..:B...13:F0x12:W3[234]...:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W3[123]...:O0:M0
Tru64 Unix 5.1:general-purpose:B...13:F0x12:W6[012]...:O0204ffff:M1[34]..:B...13:F0x12:W6[012]...:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W6[012]...:O0:M0
Tru64 Unix 5.1A:general-purpose:B...13:F0x12:W6[012]...:O0204ffff:M1[34]..:B...13:F0x12:W6[012]...:O0204ffff(01)?(030300)?:M1[34]..:B...20:F0x04:W6[012]...:O0:M0
VAX/VMS 7.1:general-purpose:B...13:F0x12:W((29..)|(3[01]..)):O0204ffff:M1[34]..:B...13:F0x12:W((29..)|(3[01]..)):O0204ffff:M1[34]..:B...20:F0x04:W((29..)|(3[01]..)):O0:M0
VxWorks:embedded:B...13:F0x12:W8[012]..:O0204ffff:M[45]..:B...13:F0x12:W8[012]..:O0204ffff(01)?(030300)?:M[45]..:B...20:F0x04:W8[012]..:O0:M0";

signatures[2] = "
AIX 4.3.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
AIX 5.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
AIX 5.3:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Alteon Load Balancer:load-balancer:B.....:F0x12:W[0-9]+:O00000000:M0:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B00000:F0:W0:O0:M0
Alteon Load Balancer:load-balancer:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 11.0:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 11.1:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 11.2:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 11.3:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 12.0:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 12.0:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 12.1:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 12.2:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 12.3:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO IOS 12.4:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CISCO PIX 6.3:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+
CISCO PIX 7.0:router:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
CatalystOS 1900:switch:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
CatalystOS 6.3:switch:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
Digital UNIX 4.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
Digital UNIX 4.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
EthernetBoard OkiLAN 8100e:switch:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x14:W[0-9]+:O0:M0
Fortigate Firewall:firewall:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O(01)?(03030.)?(0402)?(080affffffff44454144)?0204ffff:M[0-9]+:B00000:F0:W0:O0:M0
FreeBSD 3.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 3.5:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.10:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.11:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.3:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.7:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.8:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 4.9:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 5.1:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 5.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 5.3:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 5.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 5.5:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 6.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(0402)?(0000)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 6.1:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(0402)?(0000)?:M[0-9]+:B.....:F0x04:W0:O0:M0
FreeBSD 6.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(0402)?(0000)?:M[0-9]+:B.....:F0x04:W0:O0:M0
HP JetDirect Printer:printer:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
HP JetDirect Printer:printer:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
HP-UX 10.20:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
HP-UX 11.00:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(03030.)?(01)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O4e6f20544350:M0
HP-UX 11.01:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
HP-UX 11.11:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(03030.)?(01)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O4e6f20544350:M0
HP-UX 11.23:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(03030.)?(01)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O4e6f20544350:M0
HP-UX 9.05:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B00000:F0:W0:O0:M0
IRIX 6.5:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
KYOCERA Printer:printer:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x14:W[0-9]+:O0:M0
LaserWriter Printer:printer:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B00000:F0:W0:O0:M0
Linux Kernel 2.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Linux Kernel 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(0402)?(080affffffff44454144)?(01)?(03030.)?:M[0-9]+:B00000:F0:W0:O0:M0
Mac OS X 10.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(0402)?(00)?(00)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Mac OS X 10.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?(0402)?(00)?(00)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Mac OS X 10.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows 2000:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows 98:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows NT 4.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows Server 2003:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(0402)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(0402)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows Vista:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(03030.)?(01)?(0402)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows XP:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Microsoft Windows XP:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000000000000)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
NetBSD 1.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000044454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
NetBSD 3.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080a0000000044454144)?(0402)?(01)?(01)?:M[0-9]+:B.....:F0x04:W0:O0:M0
NetWare 5.1:NetWare:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(03030.)?(01)?(0402)?(01)?(01)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Nortel Switc:switch:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Nortel Switch:switch:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenBSD 3.1:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
OpenBSD 3.2:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
OpenBSD 3.3:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
OpenBSD 3.4:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
OpenBSD 3.5:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenBSD 3.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenBSD 3.7:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenBSD 3.8:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenBSD 3.9:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenBSD 4.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(01)?(0402)?(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
OpenVMS 7.2:VMS:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
RICOH Printer:printer:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W0:O0:M0
SCO OpenServer 5.0.7:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
SCO OpenServer 5.0:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
SCO UnixWare 7.1.1:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
SonicOS 3.1:Firewall:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?(01)?(01)?(080affffffff44454144)?:M[0-9]+:B.....:F0x04:W[0-9]+:O65686e63:M0
Sun Solaris 10:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O(01)?(01)?(080affffffff44454144)?0204ffff(01)?(03030.)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Sun Solaris 2.5:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Sun Solaris 2.6:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O(01)?(01)?(080affffffff44454144)?(01)?(03030.)?0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Sun Solaris 7:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O(01)?(01)?(080affffffff44454144)?(01)?(03030.)?(01)?(01)?(0402)?0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Sun Solaris 8:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O(01)?(01)?(080affffffff44454144)?(01)?(03030.)?(01)?(01)?(0402)?0204ffff:M[0-9]+:B.....:F0x04:W0:O0:M0
Sun Solaris 9:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O(01)?(01)?(080affffffff44454144)?0204ffff(01)?(03030.)?(01)?(01)?(0402)?:M[0-9]+:B.....:F0x04:W0:O0:M0
Superstack II Switch:switch:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x1c:W0:O0:M0
Tru64 5.0A:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
Tru64 5.1:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
Tru64 5.1A:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff(01)?(03030.)?:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
UnixWare 2.1.1:general-purpose:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B00000:F0:W0:O0:M0
VAX/VMS 7.1:VMS:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0
VAX/VMS unknown:VMS:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x12:W[0-9]+:O0204ffff:M[0-9]+:B.....:F0x04:W[0-9]+:O0:M0";



function sinfp_get_ip()

{
 local_var reply;

 reply = _FCT_ANON_ARGS[0];
 if ( isnull(reply) ) return NULL;

 reply = reply[0];
 if ( isnull(reply) || reply["type"] != "ip" ) return NULL;
 return reply["data"]; 
}

function sinfp_get_tcp()
{
 local_var reply;

 reply = _FCT_ANON_ARGS[0];
 if ( isnull(reply) ) return NULL;

 reply = reply[1];
 if ( isnull(reply) || reply["type"] != "tcp" ) return NULL;
 return reply["data"]; 
}

function sinfp_extract_options()
{
 local_var opt;
 local_var ret;
 local_var i;
 local_var len;

 opt = string(_FCT_ANON_ARGS[0]);
 if ( isnull(opt) ) {
	ret['mss'] = 0;
	ret['opt'] = NULL;
	return ret;
	}
 len = strlen(opt);

 for ( i = 0 ; i < len  ; )
 {
  # MSS
  if ( ord(opt[i]) ==  0x02 ) 
  {
    ret["mss"] = getword(blob:opt, pos:i + 2);
    if ( ret["mss"] != 0 )
    {
     opt[i+2] = mkbyte(0xff);
     opt[i+3] = mkbyte(0xff);
    }
    else
    {
     opt[i+2] = mkbyte(0);
     opt[i+3] = mkbyte(0);
    }
    if ( ord(opt[i+1]) == 0 ) break;
    i += ord(opt[i+1]); 
  }
  # Timestamps
  else if ( ord(opt[i]) == 0x01 )
  {
   i ++; 
  }
  else if ( ord(opt[i]) == 0x08 )
  {
   if ( getdword(blob:opt, pos:i+2) != 0 )
	 opt[i+2] = opt[i+3] = opt[i+4] = opt[i+5] = mkbyte(0xff);
    if ( ord(opt[i+1]) == 0 ) break;
    i += ord(opt[i+1]);
  }
  else if ( ord(opt[i]) != 0 ) 
  {
    if ( ord(opt[i+1]) == 0 ) break;
    i += ord(opt[i+1]);
  }
  else if ( ord(opt[i]) == 0 ){ break; }
 }

 ret["opt"] = opt;
 return ret; 
}

function sinfp_get_mss()
{
 local_var r;

 r = sinfp_extract_options(_FCT_ANON_ARGS[0]);
 if ( isnull(r) || isnull(r["mss"])) return "0";
 return r["mss"];
}

function sinfp_get_options()
{
 local_var r;
 r = sinfp_extract_options(_FCT_ANON_ARGS[0]);
 if ( !isnull(r) && !isnull(r["opt"]) )
  return hexstr(r["opt"]);
 else
  return "0";
}


function sinfp_mkbinary(r1, p1, p1_tcp, r1_tcp, p2)
{
 local_var ret;
 local_var pkt;

 if ( isnull(r1) || isnull(p1)  )
  return "00000";

 if ( isnull(p2) )
 {
  ret = "1"; # TTL
 }
 else
 {
  if ( p2["ip_ttl"] - p1["ip_ttl"] > 3 ||
       p1["ip_ttl"] - p2["ip_ttl"] > 3 ) {
	ret = "0";
	}
  else
	ret = "1";
 }

 if ( p1["ip_id"] == 0 ) ret += "0";
 else if ( p1["ip_id"] == r1["ip_id"] ) ret += "2";
 else if ( p1["ip_id"] == r1["ip_id"] + 1 ) ret += "3";
 else ret += "1";

 if ( p1["ip_off"] & IP_DF ) ret += "1";
 else ret += "0";

 if ( p1_tcp["th_seq"] == 0 ) ret += "0";
 else if ( p1_tcp["th_seq"] == r1_tcp["th_ack"] ) ret += "2";
 else if ( p1_tcp["th_seq"] == r1_tcp["th_ack"] + 1 ) ret += "3";
 else ret += "1";


 if ( p1_tcp["th_ack"] == 0 ) ret += "0";
 else if ( p1_tcp["th_ack"] == r1_tcp["th_seq"] ) ret += "2";
 else if ( p1_tcp["th_ack"] == r1_tcp["th_seq"] + 1 ) ret += "3";
 else ret += "1";
 

 return ret;
}


function sinfp_get_tcp_win()
{
 local_var ret;
 ret = _FCT_ANON_ARGS[0];
 if (! isnull(ret) ) return ret;
 else return 0;
}

function sinfp_get_tcp_flags()
{
 local_var ret;
 ret = _FCT_ANON_ARGS[0];
 if ( isnull(ret) ) return "0x00";
 else return hex(ret);
}

#
# 'Fuzzy' match when dealing with a remote network. 
# Mostly, we ignore P3, and we tolerate a deviation of
# up to 200 in the TCP MSS due to the changes a router on the
# way might add
#
function remote_sig_match()
{
 local_var a, b;
 local_var ref_a, ref_b;
 local_var flag;
 local_var i;
 local_var n;
 local_var ma, mb;
 local_var t;
 local_var P;

 if ( islocalnet() ) return FALSE;

 a = _FCT_ANON_ARGS[0];
 b = _FCT_ANON_ARGS[1];

 P = 0;
 ref_a = split(a, sep:':', keep:FALSE);
 ref_b = split(b, sep:':', keep:FALSE);
 flag = 0;
 if ( max_index(ref_a) != max_index(ref_b) ) return FALSE; # ???

 n = max_index(ref_a);
 for ( i = 0 ; i < n && flag == 0 ; i ++ )
 {
  if ( ref_a[i] =~ "^B" ) P++;
  if ( P >= 3 ) break;
  if ( ref_a[i] =~ "^M" )
  {
   ma = int(ref_a[i] - "M");
   mb = int(ref_b[i] - "M");
   if ( ma > mb )
 	{
	  t = mb;
	  mb = ma;
	  ma = t;
	}

   if ( mb - ma > 250 ) flag ++;
  }
  else if ( ref_a[i] =~ "^B" )
   {
    ma = ref_a[i];  
    mb = ref_b[i];  
    if ( ma[1] != mb[1] ) ma[1] = mb[1];
    if ( ma != mb ) flag ++;
   }
  else
   if ( ref_a[i] != ref_b[i] ) flag++;
 }
 
 if ( flag == 0 )
  return TRUE;
 else 
  return FALSE;
}

function index_by_name()
{
 local_var lines, line, name, array, ret, expr;
 ret = make_array();
 lines = split(_FCT_ANON_ARGS[0]);
 foreach line ( lines )
 {
  if ( line !~ ":.*:.*:.*:" ) continue;
  line = chomp(line);
  name = ereg_replace(pattern:"^([^:]*:[^:]*):.*", replace:"\1", string:line);
  expr = ereg_replace(pattern:"^[^:]*:[^:]*:(.*)", replace:"\1", string:line);
  array = ret[name];
  if ( isnull(array) ) 
	array = make_list(expr);
  else 
	array = make_list(array, expr);

  ret[name] = array;
 }  

 return ret;
}

function heuristic_sig(sig0, sig1, sig2, mask, ignore_p3)
{
 local_var hmask;
 local_var i, l;
 local_var elem;
 local_var ret;


 ret = "";
 l = strlen(mask);
 for ( i = 0 ; i < l ;  )
 {
  hmask[mask[i]] = int(mask[i+2]);
  i += 3;
 }  

 #B11013:F0x12:W16384:O0204ffff:M512:B11013:F0x12:W16384:O0204ffff:M512:B11020:F0x04:W16384:O0:M0

 sig0 = split(sig0, sep:':', keep:FALSE);
 if ( !isnull(sig1) )  sig1 = split(sig1, sep:':', keep:FALSE);
 if ( !isnull(sig2) )  sig2 = split(sig2, sep:':', keep:FALSE);

 l = max_index(sig0);
 for ( i = 0 ; i < l ; i ++ )
 {
  if ( i == 10 && ignore_p3 )
	{
	 ret += ":B[0-9]*:F0x[0-9a-f]*:W[0-9]*:O[0-9a-f]*:M[0-9]*";
	 return ret;
	}

  if ( i > 0 ) ret += ":";

  elem = sig0[i];
  if ( hmask[elem[0]] == 1 && ! isnull(sig1)  )
 	ret += sig1[i];
  else if ( hmask[elem[0]] == 2 && ! isnull(sig2) )
 	ret += sig2[i];
  else
 	ret += sig0[i];
 }

 return ret;
}




function sinfp_heuristic_match(signature, ignore_p3)
{
 local_var  names0, names1, sig0, sig1, sig3, sig;
 local_var  masks, mask;
 local_var  type, mask_list;
 local_var  name;
 local_var  ret;
 local_var os_name, n, m, i;

 ret = make_list();
 
 #
 # Regular list
 # 
 masks = make_list(
      'BH0FH0WH0OH0MH0',
      'BH1FH0WH0OH0MH0',
      'BH0FH0WH0OH0MH1',
      'BH0FH0WH1OH0MH1',
      'BH1FH0WH0OH0MH1',
      'BH1FH0WH1OH0MH1',
      'BH0FH0WH0OH1MH0',
      'BH1FH0WH0OH1MH0');

 mask_list["0regular"] = masks;

 #
 # Advanced masks
 #
 masks = make_list('BH0FH0WH1OH1MH1',
      'BH1FH0WH1OH1MH1',
      'BH0FH0WH1OH0MH2',
      'BH0FH0WH2OH0MH1',
      'BH0FH0WH2OH0MH2',
      'BH0FH0WH0OH2MH0',
      'BH0FH0WH1OH2MH1',
      'BH2FH0WH0OH0MH1',
      'BH2FH0WH1OH0MH1',
      'BH2FH0WH1OH1MH1',
      'BH2FH0WH2OH0MH2',
      'BH0FH0WH2OH1MH2',
      'BH1FH0WH2OH1MH2',
      'BH2FH2WH2OH2MH2');


 mask_list["1advanced"] = masks;
 names0 = index_by_name(signatures[0]);
 names1 = index_by_name(signatures[1]);
 names2 = index_by_name(signatures[2]);

 foreach type ( sort(keys(mask_list)) )
 {
  masks = mask_list[type];
  foreach mask ( masks )
  {
  foreach name ( keys(names0) )
  {
    foreach sig0 ( names0[name] )
    {
     if ( isnull(names1[name]) ) 
	{
	   sig = heuristic_sig(sig0:sig0, mask:mask, ignore_p3:ignore_p3);
	  if ( ereg(pattern:sig, string:signature) )  ret[max_index(ret)] = name; 
	}
     else
     foreach sig1 ( names1[name] )
      {
        if ( isnull(names2[name]) ) 
 	{
	   sig = heuristic_sig(sig0:sig0, sig1:sig1, mask:mask, ignore_p3:ignore_p3);
	  if ( ereg(pattern:sig, string:signature) ) ret[max_index(ret)] = name; 
	}
        else
	  foreach sig2 ( names2[name] )
          {
	   sig = heuristic_sig(sig0:sig0, sig1:sig1, sig2:sig2, mask:mask, ignore_p3:ignore_p3);
	  if ( ereg(pattern:sig, string:signature) )  ret[max_index(ret)] = name; 
          }
      } 
    }
   } 
  if (max_index(ret) > 0 ) break; 
  }
  if (max_index(ret) > 0 ) break;
 }

 if ( type == "1advanced" ) confidence -= 17;

 os_name = sort(ret);
 m = max_index(os_name);
 if( m == 0 ) return NULL;
 ret = NULL;
 for ( i = 0 ; i < m ; i ++ )
 {
  if ( i > 0 && os_name[i]  == os_name[i-1] ) continue;
  else ret += os_name[i] + '\n';
 }
 return ret;
}

function sinfp_match(signature )
{
 local_var line;
 local_var os_name;
 local_var n;
 local_var P;
 local_var sig;
 local_var s;
 local_var i, m;
 local_var ignore_p3;
 local_var clean_sig;
 local_var str;
 local_var ret;
 local_var sigs;

 if ( signature =~ "B00000:F0x00:W0:O0:M0$" ) 
	ignore_p3 = 1; 
 else
	ignore_p3 = 0;

 n = 0;
 P = 0;

 sigs = signatures[0];
 
 foreach line ( split(sigs) )
 {
  if ( line =~ "^#" ) continue;
  if ( line !~ ":.*:.*:" ) continue;
  clean_sig = NULL;
	
 sig = split(line, sep:':', keep:FALSE);
 if ( ignore_p3 )
 {
  str = sig[2];
  str[1] = "1";
  sig[2] = str; 
 }
 m = max_index(sig);
 P = 0;
 for ( i = 2; i < m ; i ++ )
 {
  if ( string(sig[i]) =~ "^B" ) {
	P++;
	if ( P == 3 && ignore_p3 ) {
		 clean_sig = strcat(clean_sig, ":B00000:F0x00:W0:O0:M0");
		 break;
		}
 	}

   if ( ! isnull(clean_sig) )
    clean_sig = strcat(clean_sig, ":", sig[i]);
  else
    clean_sig = sig[i];
 }
  
  if ( strstr(clean_sig, signature)  ) 
   os_name[n++] = ereg_replace(pattern:"^([^:]*:[^:]*):.*", string:chomp(line), replace:"\1");
}

 if ( n == 0 ) return NULL;
 os_name = sort(os_name);
 m = max_index(os_name);
 if( m == 0 ) return NULL;
 for ( i = 0 ; i < m ; i ++ )
 {
  if ( i > 0 && os_name[i]  == os_name[i-1] ) continue;
  else ret += os_name[i] + '\n';
 }
 

 return ret;
}

function os_name_split()
{
 local_var str;
 local_var array;
 local_var line;
 local_var os; 
 local_var type;
 local_var ret_os;
 local_var ret_type;
 local_var ret;
 local_var n;

 ret_type = NULL;
 array = split(_FCT_ANON_ARGS[0], keep:FALSE);
 foreach line ( array ) 
 {
  os = ereg_replace(pattern:"^([^:]*):.*", string:line, replace:"\1");
  type = ereg_replace(pattern:"^[^:]*:(.*)", string:line, replace:"\1");
  if ( ret_type && ret_type != type ) ret_type = "unknown";
  else ret_type = type;
  if ( ret_os ) ret_os += '\n';
  ret_os += os;
  n++;
 }

 
 ret["num"] = n;
 if( ret_type != "unknown" ) ret["type"] = ret_type;
 ret["os"] = ret_os;
 return ret;
}


RawSendViaOperatingSystem = 1;
#if ( ! COMMAND_LINE )
{
dport = get_host_open_port();
if (! dport ) exit(0);

sport1 = rand() % 64000 + 1024;
sport2 = sport1 + 1;
sport3 = sport2 + 1;

ip1 = ip(ip_p:IPPROTO_TCP, ip_ttl:255, ip_off:0);
ip2 = ip(ip_p:IPPROTO_TCP, ip_ttl:255, ip_off:0);
ip3 = ip(ip_p:IPPROTO_TCP, ip_ttl:255, ip_off:0);

tcp1 = tcp(th_flags:TH_SYN, th_dport:dport, th_sport:sport1, th_win:5840, th_seq:rand(), th_ack:rand());


tcp = tcp(th_flags:TH_SYN, th_dport:dport, th_sport:sport2, th_win:5840, th_seq:rand(), th_ack:rand());
tcp = tcp_insert_option(tcp:tcp, type:2, length:4, data:mkword(0x05b4));
tcp = tcp_insert_option(tcp:tcp, type:8, length:10, data:"DEAD" + mkdword(0));
tcp = tcp_insert_option(tcp:tcp, type:3, length:3, data:mkbyte(1));
tcp = tcp_insert_option(tcp:tcp, type:4, length:2);
tcp2 = tcp_insert_option(tcp:tcp, type:0);


tcp3 = tcp(th_flags:TH_SYN|TH_ACK, th_dport:dport, th_sport:sport3, th_win:5840, th_seq:rand(), th_ack:rand());

pkt1 = mkpacket(ip1, tcp1);
pkt2 = mkpacket(ip2, tcp2);
pkt3 = mkpacket(ip3, tcp3);




reply1 = send_packet(pkt1, pcap_filter:"tcp and src port " + dport + " and dst port " + sport1 + " and src host " + get_host_ip() + " and dst host " + this_host());
if ( ! reply1 ) exit(0);
reply2 = send_packet(pkt2, pcap_filter:"tcp and src port " + dport + " and dst port " + sport2 + " and src host " + get_host_ip() + " and dst host " + this_host());
if ( ! reply2 ) exit(0);
reply3 = send_packet(pkt3, pcap_filter:"tcp and src port " + dport + " and dst port " + sport3 + " and src host " + get_host_ip() + " and dst host " + this_host());


if ( reply1 )
 {
  split1 = packet_split(reply1);
  r1_ip    = sinfp_get_ip(split1);
  r1_tcp   = sinfp_get_tcp(split1);
  if ( (r1_tcp["th_flags"] & (TH_SYN|TH_ACK)) != TH_SYN|TH_ACK ) exit(0);
 }

if ( reply2 )
 {
  split2 = packet_split(reply2);
  r2_ip    = sinfp_get_ip(split2);
  r2_tcp   = sinfp_get_tcp(split2);
  if ( (r2_tcp["th_flags"] & (TH_SYN|TH_ACK)) != TH_SYN|TH_ACK ) exit(0);
 }

if ( reply3 )
 {
  split3 = packet_split(reply3);
  r3_ip    = sinfp_get_ip(split3);
  r3_tcp   = sinfp_get_tcp(split3);
 }


P1 = strcat(P1, "B", sinfp_mkbinary(p1:r1_ip, r1:ip1["data"], p1_tcp:r1_tcp, r1_tcp:tcp1["data"]));
P1 = strcat(P1, ":F", sinfp_get_tcp_flags(r1_tcp["th_flags"]));
P1 = strcat(P1, ":W", sinfp_get_tcp_win(r1_tcp["th_win"]));
P1 = strcat(P1, ":O",  sinfp_get_options(r1_tcp["options"]));
P1 = strcat(P1, ":M", sinfp_get_mss(r1_tcp["options"]));

P2 = strcat("B", sinfp_mkbinary(p1:r2_ip, r1:ip2["data"], p1_tcp:r2_tcp, r1_tcp:tcp2["data"]));
P2 = strcat(P2, ":F", sinfp_get_tcp_flags(r2_tcp["th_flags"]));
P2 = strcat(P2, ":W", sinfp_get_tcp_win(r2_tcp["th_win"]));
P2 = strcat(P2, ":O",  sinfp_get_options(r2_tcp["options"]));
P2 = strcat(P2, ":M", sinfp_get_mss(r2_tcp["options"]));

bin = sinfp_mkbinary(p1:r3_ip, r1:ip3["data"], p1_tcp:r3_tcp, r1_tcp:tcp3["data"], p2:r3_ip);
if ( r3_ip["ip_ttl"] != r1_ip["ip_ttl"] )
  bin[0] = "0";
P3 = strcat(P3, "B", bin);
P3 = strcat(P3, ":F", sinfp_get_tcp_flags(r3_tcp["th_flags"]));
P3 = strcat(P3, ":W", sinfp_get_tcp_win(r3_tcp["th_win"]));
P3 = strcat(P3, ":O",  sinfp_get_options(r3_tcp["options"]));
P3 = strcat(P3, ":M", sinfp_get_mss(r3_tcp["options"]));
}
#else
#{
# display("Enter signature:\n");
# P1 = prompt("") - "P1:";
# P1 = substr(P1, 0, strlen(P1) - 2);
# P2 = prompt("") - "P2:";
# P2 = substr(P2, 0, strlen(P2) - 2);
# P3 = prompt("") - "P3:";
# display("\n");
#}


signature = strcat(P1,":", P2,":",P3);

line = egrep(string:signatures, pattern:signature);


confidence = 70;
osname = sinfp_match(signature:signature);
if ( isnull(osname)  ) 
{
 confidence -= 5;
 osname = sinfp_heuristic_match(signature:signature, ignore_p3:FALSE);
 if ( isnull(osname) ) 
 {
  osname = sinfp_heuristic_match(signature:signature, ignore_p3:TRUE);
 }
}


#if ( COMMAND_LINE ) {
#	display("osname = ", osname, "\n");
#	display("confidence = ", confidence, "\n");
#	}
P4 = string(NASL_LEVEL, "_", ENGINE_VERSION, "_p=", dport);
if ( ! islocalnet() ) P4 += "R";
signature = strcat('\n   P1:', P1,":", '\n   P2:', P2,":", '\n   P3:', P3, '\n   P4:', P4 );


if ( ! isnull(osname) )
{
 data = os_name_split(osname);
 if ( data["num"] > 5 ) exit(0);
}

set_kb_item(name:"Host/OS/SinFP/Fingerprint", value:signature);


if ( !isnull(osname) )
{
 data = os_name_split(osname);
 if ( data["num"] > 5 ) exit(0);
 set_kb_item(name:"Host/OS/SinFP", value:data["os"]);
 if ( data["type"] )
  set_kb_item(name:"Host/OS/SinFP/Type", value:data["type"]);
 if ( data["num"] > 1 ) confidence -= 11;

 set_kb_item(name:"Host/OS/SinFP/Confidence", value:confidence);
}
