#
# (C) Tenable Network Security, Inc.
#

if (description)
{
  script_id(29831);
  script_version("$Revision: 1.5 $");

  name["english"] = "OS Identification : telnet banner";
  script_name(english:name["english"]);

  desc["english"] = "
This script attempts to identify the Operating System type and 
version by looking at the data returned by the remote telnet banner

Risk factor : None";

  script_description(english:desc["english"]);
 
  summary["english"] = "Determines the remote operating system";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
  family["english"] = "General";
  script_family(english:family["english"]);
  script_dependencies("telnetserver_detect_type_nd_version.nasl");
  script_require_keys("Services/telnet/banner/23");
 
  exit(0);
}


include("telnet_func.inc");
banner = get_telnet_banner(port:23);
if ( ! banner ) exit(0);
confidence = 51;
if ( "SunOS 5" >< banner )
{
 line = egrep(pattern:"SunOS 5\.[0-9]", string:banner);
 if ( line && line != banner )
 {
  version = ereg_replace(pattern:"SunOS 5\.([0-9]+).*", string:line, replace:"\1");
  if (  int(version) ) {
	set_kb_item(name:"Host/OS/telnet", value:"Sun Solaris " + int(version));
	set_kb_item(name:"Host/OS/telnet/Confidence", value:confidence);
	set_kb_item(name:"Host/OS/telnet/Type", value:"general-purpose");
	}
 }
}
else if (egrep(pattern:"Serial Number .* MAC address", string:banner) &&
 	 "Software version " >< banner &&
	 "Press Enter to go into Setup Mode, wait to close" >< banner )
{
	set_kb_item(name:"Host/OS/telnet", value:"Modbus/TCP to RTU Bridge");
	set_kb_item(name:"Host/OS/telnet/Confidence", value:98);
	set_kb_item(name:"Host/OS/telnet/Type", value:"embedded");
}

