#
# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License. 
#


if (description) {
 script_id(28292);
 script_version("$Revision: 1.2 $");

 name["english"] = "OSSIM Server Detection";
 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

An ossim-server daemon is listening on the remote port. 

Description :

The remote system is running an ossim-server daemon. OSSIM (Open Source
Security Information Management) is a centralized security management 
information system, and the ossim-server provides centralized access to the
backend database and framework.

See also :

http://www.ossim.net/

Solution :

If possible, filter incoming connections to the service so that it is
used by trusted sources only.

Risk factor :

None";
 script_description(english:desc["english"]);
 summary["english"] = "Checks for an OSSIM server";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);
 script_family(english:"Service detection");
 script_copyright(english:"This script is Copyright (C) 2007 Ferdy Riphagen");

 script_dependencies("find_service1.nasl");
 script_require_ports("Services/unknown", 40001);
 exit(0);
}

include("global_settings.inc");
include("misc_func.inc");

if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery")  ) {
  port = get_unknown_svc(40001);
  if (!port) exit(0);
}
else port = 40001;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (soc) { 
	rand = rand() % 10;
	data = 'connect id="' + rand + '" type="sensor"\n'; 
	send(socket:soc, data:data);
	recv = recv(socket:soc, length:64, min:10);

	if (strlen(recv) && recv == 'ok id="' + rand + '"\n') {
		security_note(port:port);
		register_service(port:port, ipproto:"tcp", proto:"ossim_server");
	}
	close(soc);
}
