# nnposter
# GPL


desc["english"] = "
Synopsis :

The remote web server is used to manage a network device. 

Description :

The remote web server is a Packeteer web management interface. 

See also :

http://www.packeteer.com/

Solution :

Filter incoming traffic to this port.

Risk factor :

None";


desc_unencrypted["english"] = "
Synopsis :

The remote web server is used to manage a network device. 

Description :

The remote web server is an unencrypted Packeteer web management
interface. 

See also :

http://www.packeteer.com/

Solution :

Consider disabling this port completely and using only HTTPS.  And
filter incoming traffic to this port. 

Risk factor : 

Low / CVSS Base Score : 2.3
(AV:R/AC:L/Au:NR/C:P/I:N/A:N/B:N)";


if (description)
    {
    script_id(25568);
    script_version ("$Revision: 1.2 $");

    name["english"]="Packeteer Web Management Interface Detection";
    script_name(english:name["english"]);

    script_description(english:desc["english"]);

    summary["english"]="Detects Packeteer web management interface";
    script_summary(english:summary["english"]);

    family["english"]="CGI abuses";
    script_family(english:family["english"]);

    script_category(ACT_GATHER_INFO);

    script_copyright(english:"This script is Copyright (c) 2006-2007 nnposter");
    script_dependencies("http_version.nasl");
    script_require_ports("Services/www",80);
    exit(0);
    }

# Notes:
# - Does not work with http_keepalive_send_recv() for some reason.
#   Resorting to http_send_recv()


include("http_func.inc");
#include("http_keepalive.inc");
include("misc_func.inc");


port=get_http_port(default:80);
if (!get_tcp_port_state(port)) exit(0);
encaps = get_kb_item("Transports/TCP/"+port);

#resp=http_keepalive_send_recv(port:port,data:http_get(item:"/login.htm",port:port));
resp=http_send_recv(port:port,data:http_get(item:"/login.htm",port:port));
if (!resp) exit(0);

server=egrep(pattern:"^Server: *httpd/1\.",string:resp,icase:TRUE);
cookie=egrep(pattern:"^Set-Cookie: *[^a-z0-9]PScfgstr=",string:resp,icase:TRUE);
if (!server || !cookie) exit(0);

product="(unknown)";
# 8.x product extraction
match=eregmatch(pattern:': ([a-z]+) +Login</title>',string:resp,icase:TRUE);
if (isnull(match))
    # 7.x product extraction
    match=eregmatch(pattern:'\n([a-zA-Z]+) +/login\\.htm\n',string:resp);
if (!isnull(match)) product=match[1];

replace_or_set_kb_item(name:"www/packeteer",value:TRUE);
replace_or_set_kb_item(name:"www/"+port+"/packeteer",value:product);
if (product=="PacketShaper")
    replace_or_set_kb_item(name:"Services/www/"+port+"/embedded",value:TRUE);

issue="A Packeteer "+product+" web management interface is running on this port.";
if (encaps && (encaps >= ENCAPS_SSLv2 && encaps <= ENCAPS_TLSv1))
    {
    report = string(
      desc["english"],
      "\n\n",
      "Plugin output :\n",
      "\n",
      issue
    );
    security_note(port:port,data:report);
    }
else
    {
    report = string(
      desc_unencrypted["english"],
      "\n\n",
      "Plugin output :\n",
      "\n",
      issue
    );
    security_note(port:port,data:report);
    }
