#
# (C) Tenable Network Security
#


if (description) {
  script_id(18417);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2005-1806");
  script_bugtraq_id(13808);

  name["english"] = "PeerCast Format String Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
Synopsis :

The remote peer-to-peer application is affected by a format string
vulnerability. 

Description :

The version of PeerCast installed on the remote host suffers from a
format string vulnerability.  An attacker can issue requests
containing format specifiers that will crash the server and
potentially permit arbitrary code execution subject to privileges of
the user under which the affected application runs. 

See also : 

http://www.gulftech.org/?node=research&article_id=00077-05282005
http://archives.neohapsis.com/archives/bugtraq/2005-05/0335.html
http://www.peercast.org/forum/viewtopic.php?p=11596

Solution : 

Upgrade to PeerCast 0.1212 or later.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for format string vulnerability in PeerCast";
  script_summary(english:summary["english"]);
 
  script_category(ACT_MIXED_ATTACK);
  script_family(english:"Gain a shell remotely");

  script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");

  script_dependencies("peercast_installed.nasl");
  script_require_keys("PeerCast/installed");
  script_require_ports("Services/www", 7144, 7145);

  exit(0);
}


if (!get_kb_item("PeerCast/installed")) exit(0);


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");


list = get_kb_list("PeerCast/*/version");
if (isnull(list)) exit(0);

foreach key (keys(list))
{
  port = key - "PeerCast/" - "/version";
  ver = list[key];

  if (get_port_state(port))
  {
    # If safe checks are enabled...
    if (safe_checks())
    {
      # Check the version.
      vuln = FALSE;

      if (ver =~ "^[0-9]\.[0-9]+$")
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (iver[0] == 0 && iver[1] < 1212) vuln = TRUE;
      }
      else if (report_paranoia > 1) vuln = TRUE;

      if (vuln)
      {
       report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "According to its Server response header, the version of PeerCast on the\n",
          "remote host is :\n",
          "\n",
          "  ", ver, "\n"
        );
        security_hole(port:port, data:report);
        break;
      }
    }
    # Otherwise...
    else
    {
      # Make sure the server's up.
      soc = http_open_socket(port);
      if (!soc || http_is_dead(port:port)) exit(1);

      # Try to crash it.
      req = http_get(item:"/html/en/index.htm%n", port:port);
      send(socket:soc, data:req);
      res = http_recv(socket:soc);
      http_close_socket(soc);

      # There's a problem if the server's down.
      if (http_is_dead(port:port))
      {
        security_hole(port);
        exit(0);
      }
    }
  }
}
