#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(24906);
  script_version("$Revision: 1.7 $");
  script_cve_id(
    "CVE-2007-0905",
    "CVE-2007-0906",
    "CVE-2007-0907",
    "CVE-2007-0908",
    "CVE-2007-0909",
    "CVE-2007-0910",
    "CVE-2007-1376",
    "CVE-2007-1378",
    "CVE-2007-1379",
    "CVE-2007-1380",
    "CVE-2007-1700",
    "CVE-2007-1701",
    "CVE-2007-1777",
    "CVE-2007-1825",
    "CVE-2007-1884",
    "CVE-2007-1885",
    "CVE-2007-1886",
    "CVE-2007-1887",
    "CVE-2007-1890"
  );
  script_bugtraq_id(
    22496, 
    22805, 
    22806, 
    22833, 
    22862,
    23119, 
    23120, 
    23169, 
    23219,
    23233, 
    23234, 
    23235,
    23236
  );
  script_xref(name:"OSVDB", value:"32776");
  script_xref(name:"OSVDB", value:"32779");
  script_xref(name:"OSVDB", value:"32781");
  script_xref(name:"OSVDB", value:"33955");
  script_xref(name:"OSVDB", value:"34691");
  script_xref(name:"OSVDB", value:"34767");

  script_name(english:"PHP < 4.4.5 Multiple Vulnerabilities");
  script_summary(english:"Checks version of PHP");
 
  desc = "
Synopsis :

The remote web server uses a version of PHP that is affected by
multiple flaws. 

Description :

According to its banner, the version of PHP installed on the remote
host is older than 4.4.5.  Such versions may be affected by several
issues, including buffer overflows, format string vulnerabilities,
arbitrary code execution, 'safe_mode' and 'open_basedir' bypasses, and
clobbering of super-globals. 

See also :

http://www.php.net/releases/4_4_5.php

Solution :

Upgrade to PHP version 4.4.5 or later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("backport.inc");
include("global_settings.inc");
include("http_func.inc");


# nb: banner checks of PHP are prone to false-positives so we only
#     run the check if reporting is paranoid.
if (report_paranoia <= 1) exit(0);


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


banner = get_http_banner(port:port);
if (banner)
{
  ver = get_php_version(banner:banner);
  if (ver && ver =~ "PHP/(3\.|4\.([0-3]\.|4\.[0-4]($|[^0-9])))")
    security_hole(port);
}
