#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
an information disclosure vulnerability. 

Description :

The remote host is running PHP-Blogger, a photo blog script written in
PHP. 

The version of PHP-Blogger installed on the remote host stores
configuration information in the file 'data/pref.db' and fails to
restrict access to this file.  By issuing a direct request for the
file, an attacker can gain access to sensitive information, such as
the password hash, which can in turn allow him to gain administrative
access to the application itself. 

See also :

http://forcehacker.com/forum/viewtopic.php?t=2352

Solution :

Limit access to PHP-Blogger's 'data' directory using, say, a .htaccess
file. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(25822);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-4157");
  script_bugtraq_id(25143);
  script_xref(name:"OSVDB", value:"38706");

  script_name(english:"PHP-Blogger pref.db Information Disclosure Vulnerability");
  script_summary(english:"Tries to retrieve data/pref.db");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/php-blogger", "/phpblogger", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to grab the database.
  req = http_get(item:string(dir, "/data/pref.db"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it looks like the exploit worked...
  if ("posts_per_page=" >< res)
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of the file 'data/pref.db' that Nessus\n",
      "was able to read from the remote host :\n",
      "\n",
      res
    );
    security_warning(port:port, data:report);
    exit(0);
  }
}
