#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14613);
 script_cve_id("CVE-2004-1651");
 script_bugtraq_id(11080);
 script_xref(name:"OSVDB", value:"9450");
 script_xref(name:"OSVDB", value:"9451");
 script_version("$Revision: 1.10 $");
 
 name["english"] = "phpScheduleIt HTML Injection Vulnerabilities";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains a PHP application that is affected by
multiple vulnerabilities. 

Description :

The remote host is running phpScheduleIt, a web-based reservation
system written in PHP. 

According to its banner, this version is reported vulnerable to HTML
injection issues.  For example, an attacker may add malicious HTML and
Javascript code in a schedule page if he has the right to edit the
'Schedule Name' field.  This field is not properly sanitized.  The
malicious code would be executed by a victim web browser displaying
this schedule. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2004-08/0417.html
http://archives.neohapsis.com/archives/bugtraq/2004-09/0216.html

Solution : 

Upgrade to phpScheduleIt version 1.0.0 or later.

Risk factor : 

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of an XSS bug in phpScheduleIt";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2007 Tenable Network Security");
 family["english"] = "CGI abuses : XSS";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

function check(loc)
{
 local_var r, req, str, version;
 global_var port;

 req = http_get(item:string(loc, "/index.php"), port:port);
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 str = egrep(pattern:"phpScheduleIt v", string:r);
 if ( str )
 {
        version = ereg_replace(pattern:".*phpScheduleIt v([^<]*)<.*", string:str, replace:"\1");
	if ( loc == "" ) loc = "/";
	set_kb_item(name:"www/" + port + "/phpScheduleIt", value:version + " under " + loc);

	if ( ereg(pattern:"^(0\..*|1\.0\.0 RC1)", string:version) ) 
        {
 	security_warning(port);
	exit(0);
        }
 }
}


foreach dir (cgi_dirs())
{
 check(loc:dir);
}
