#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10618);
 script_bugtraq_id(2381);
 script_version ("$Revision: 1.14 $");
 script_cve_id("CVE-2001-0302", "CVE-2001-0303");
 
 name["english"] = "Pi3Web tstisap.dll overflow";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains a script that is affected by several
issues. 

Description :

The '/isapi/tstisapi.dll' cgi is installed.  This CGI has a well-known
security flaw that lets anyone execute arbitrary commands with the
privileges of the http service. 

In addition, it discloses the physical path to the web root if an
invalid URL is requested. 

Solution : 

Remove the script from /isapi.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of /isapi/tstisapi.dll";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port:port);
if ( "Pi3Web/" >!< banner ) exit(0);

soc = http_open_socket(port);

if(soc)
{
 req = http_get(item:"/isapi/tstisapi.dll",
		port:port);

 send(socket:soc, data:req);
 r = http_recv(socket:soc);
 http_close_socket(soc);
 if("SERVER_SOFTWARE=Pi3Web/1.0.1" >< r)security_hole(port);
}
