#
# (C) Tenable Network Security
#


 desc["english"] = "
Synopsis :

It is possible to bypass the authentication scheme of the remote FTP
server. 

Description :

The remote host is running ProFTPd.  Due to a bug in the way the
remote server is configured and the way it processes the USER and PASS
commands, it is possible to log into the remote system by supplying
invalid credentials.

See also :

http://bugs.proftpd.org/show_bug.cgi?id=2922

Solution : 

Upgrade to the latest (CVS) version of this software.

Risk factor : 

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";


if(description)
{
 script_id(25040);
 script_version ("$Revision: 1.6 $");

 script_cve_id("CVE-2007-2165");
 script_bugtraq_id(23546);
 script_xref(name:"OSVDB", value:"34602");
 
 name["english"] = "ProFTPD AUTH Multiple Authentication Module Security Bypass Vulnerability";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Attempts to bypass FTP authentication";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");
 family["english"] = "FTP";
 script_family(english:family["english"]);
 script_dependencie("DDI_FTP_Any_User_Login.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here
#
include('ftp_func.inc');

port = get_kb_item("Services/ftp");
if ( ! port ) port = 21;
if ( get_kb_item("ftp/" + port + "/AnyUser") ) exit(0);

if(! get_port_state(port)) exit(0);
banner = get_ftp_banner(port:port);
if ( ! banner || "ProFTPD" >!< banner ) exit(0);

soc = open_sock_tcp(port);
if( ! soc ) exit(0);
#
# Debian ships with proxy,www-data,irc,list,backup. Try 'bin' for good measure as well
#
foreach user (make_list("proxy", "clamav", "bin"))
{
  pass = "*";
  if (ftp_authenticate(socket:soc, user:user, pass:pass))
  {
    listing = NULL;

    port2 = ftp_pasv(socket:soc);
    if (port2)
    {
      soc2 = open_sock_tcp(port2, transport:get_port_transport(port));
      if (soc2)
      {
        send(socket:soc, data:'LIST\r\n');
        listing = ftp_recv_listing(socket:soc2);
        close(soc2);
      }
    }

    info = 'Nessus was able to log in using the credentials "' + user + '/' + pass + '"';
    if (listing)
      info = info + ' and obtain\nthe following listing of the FTP root :\n' + listing;
    else
      info = info + '.\n';

    report = string(
      desc["english"],
      "\n\n",
      "Plugin output :\n",
      "\n",
      info
    );
    security_warning(port:port, data:report);

    break;
  }
}
close(soc);
