#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote Windows host contains an application that is affected by
multiple issues. 

Description :

The version of QuickTime installed on the remote Windows host is older
than 7.3.  Such versions contain several vulnerabilities that may
allow an attacker to execute arbitrary code on the remote host if he
can trick the user to open a specially-crafted file with QuickTime. 

See also :

http://docs.info.apple.com/article.html?artnum=306896
http://lists.apple.com/archives/security-announce/2007/Nov/msg00000.html

Solution :

Either use QuickTime's Software Update preference to upgrade to the
latest version or manually upgrade to QuickTime 7.3 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(27626);
  script_version("$Revision: 1.5 $");

  script_cve_id(
    "CVE-2007-2395",
    "CVE-2007-3750",
    "CVE-2007-3751",
    "CVE-2007-4672",
    "CVE-2007-4674",
    "CVE-2007-4675",
    "CVE-2007-4676",
    "CVE-2007-4677"
  );
  script_bugtraq_id(26338, 26339, 26340, 26341, 26342, 26344, 26345, 26443);
  script_xref(name:"OSVDB", value:"38544");
  script_xref(name:"OSVDB", value:"38545");
  script_xref(name:"OSVDB", value:"38546");
  script_xref(name:"OSVDB", value:"38547");
  script_xref(name:"OSVDB", value:"38548");
  script_xref(name:"OSVDB", value:"38549");
  script_xref(name:"OSVDB", value:"38550");

  script_name(english:"QuickTime < 7.3 (Windows)");
  script_summary(english:"Checks version of QuickTime on Windows");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("quicktime_installed.nasl");
  script_require_keys("SMB/QuickTime/Version");

  exit(0);
}


ver = get_kb_item("SMB/QuickTime/Version");
if (isnull(ver)) exit(0);

iver = split(ver, sep:'.', keep:FALSE);
for (i=0; i<max_index(iver); i++)
  iver[i] = int(iver[i]);

if (iver[0] < 7 || (iver[0] == 7 && iver[1] < 3)) 
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Version ", ver, " of QuickTime is currently installed\n",
    "on the remote host.\n"
  );
  security_hole(port:get_kb_item("SMB/transport"), data:report);
}
