#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30204);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0234");
  script_bugtraq_id(27225);
  script_xref(name:"OSVDB", value:"40382");

  script_name(english:"QuickTime < 7.4.1 (Windows)");
  script_summary(english:"Checks version of QuickTime on Windows");
 
  desc = "
Synopsis :

The remote Windows host contains an application that is affected by a
buffer overflow vulnerability. 

Description :

The version of QuickTime installed on the remote Windows host is older
than 7.4.1.  Such versions contain a heap buffer overflow in the
application's handling of HTTP responses when RTSP tunneling is
enabled.  If an attacker can trick a user to visit a specially-crafted
webpage, he may be able to to execute arbitrary code on the remote
host subject to the user's privileges. 

See also :

http://www.securityfocus.com/archive/1/486091
http://docs.info.apple.com/article.html?artnum=307407
http://lists.apple.com/archives/security-announce/2008/Feb/msg00001.html

Solution :

Either use QuickTime's Software Update preference to upgrade to the
latest version or manually upgrade to QuickTime 7.4.1 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("quicktime_installed.nasl");
  script_require_keys("SMB/QuickTime/Version");

  exit(0);
}


include("global_settings.inc");


ver = get_kb_item("SMB/QuickTime/Version");
if (isnull(ver)) exit(0);

iver = split(ver, sep:'.', keep:FALSE);
for (i=0; i<max_index(iver); i++)
  iver[i] = int(iver[i]);

if (
  iver[0] < 7 || 
  (
    iver[0] == 7 && 
    (
      iver[1] < 4 ||
      (iver[1] == 4 && iver[2] < 1)
    )
  )
)
{
  if (report_verbosity)
  {
    report = string(
      "\n",
      "Version ", ver, " of QuickTime is currently installed\n",
      "on the remote host.\n"
    );
    security_hole(port:get_kb_item("SMB/transport"), extra:report);
  }
  else security_hole(get_kb_item("SMB/transport"));
}
