#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

There is a media player installed on the remote Windows host. 

Description :

QuickTime is installed on the remote host.  QuickTime is a popular
media player / plug-in that handles various types of music and video
files. 

Make sure the use of this program fits with your corporate security
policy. 

See also :

http://www.apple.com/quicktime/

Solution :

Remove this software if its use does not match your corporate security
policy. 

Risk factor : 

None";


if (description)
{
  script_id(21561);
  script_version("$Revision: 1.2 $");

  script_name(english:"QuickTime Detection");
  script_summary(english:"Checks Windows registry for QuickTime");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("http_func.inc");
include("misc_func.inc");
include("smb_func.inc");


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);

name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Determine where it's installed.
path = NULL;
key = "SOFTWARE\Apple Computer, Inc.\QuickTime";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  item = RegQueryValue(handle:key_h, item:"InstallDir");
  if (!isnull(item))
  {
    path = item[1];
    path =  ereg_replace(pattern:"(.*)\\", replace:"\1", string:path);
  }

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
NetUseDel(close:FALSE);

# If it is...
ver = NULL;
if (path)
{
  # Determine its version from the executable itself.
  share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
  exe   = ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\QuickTimePlayer.exe", string:path);

  rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
  if (rc != 1)
  {
    NetUseDel();
    exit(0);
  }

  fh = CreateFile(
    file:exe,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );
  if (!isnull(fh))
  {
    version = GetFileVersion(handle:fh);
    ver = string(version[0], ".", version[1], ".", version[2], ".", version[3]);
    CloseFile(handle:fh);
  }
}
NetUseDel();


# Generate report and save info in KB.
if (path && ver) 
{
  set_kb_item(name:"SMB/QuickTime/Version", value:ver);
  set_kb_item(name:"SMB/QuickTime/Path",    value:path);

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "  Version : ", ver, "\n",
    "  Path    : ", path, "\n"
  );
  security_note(port:port, data:report);
}
