#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25573);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-3410");
  script_bugtraq_id(24658);
  script_xref(name:"OSVDB", value:"37374");
  script_xref(name:"OSVDB", value:"38342");

  script_name(english:"RealPlayer for Windows < 6.0.12.1578");
  script_summary(english:"Checks version of RealPlayer for Windows");
 
  desc = "
Synopsis :

The remote Windows application is affected by a buffer overflow
vulnerability. 

Description :

According to its version number, the installed version of RealPlayer
on the remote Windows host contains a stack buffer overflow that can
be triggered by a specially-crafted SMIL file, perhaps accessed over
the web using the CLSID 'CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA'.  A
remote attacker may be able to exploit this issue to execute arbitrary
code subject to the user's privileges on the affected host. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=547
http://www.securityfocus.com/archive/1/472295/30/0/threaded

Solution :

Upgrading to the latest version of the product supposedly resolves the
issue, although the vendor has not confirmed that. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("realplayer_detect.nasl");
  script_require_keys("SMB/RealPlayer/Product", "SMB/RealPlayer/Version");

  exit(0);
}


# nb: there's no information regarding whether RealOne Player 
#     or RealPlayer Enterprise are also affected.
prod = get_kb_item("SMB/RealPlayer/Product");
if (!prod || prod != "RealPlayer") exit(0);


# There's a problem if the version is before 6.0.12.1578.
ver = get_kb_item("SMB/RealPlayer/Version");
if (!ver) exit(0);

iver = split(ver, sep:'.', keep:FALSE);
if (
  int(iver[0]) < 6 ||
  (
    int(iver[0]) == 6 &&
    int(iver[1]) == 0 && 
    (
      int(iver[2]) < 12 ||
      (int(iver[2]) == 12 && int(iver[3]) < 1578)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
