#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15991);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2004-0110", "CVE-2004-0989");

 name["english"] = "RHSA-2004-650: libxml";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated libxml package that fixes multiple buffer overflows is now
  available.

  The libxml package contains a library for manipulating XML files.

  Multiple buffer overflow bugs have been found in libxml versions prior to
  2.6.14. If an attacker can trick a user into passing a specially crafted
  FTP URL or FTP proxy URL to an application that uses the vulnerable
  functions of libxml, it could be possible to execute arbitrary code.
  Additionally, if an attacker can return a specially crafted DNS request to
  libxml, it could be possible to execute arbitrary code. The Common
  Vulnerabilities and Exposures project (cve.mitre.org) has assigned the name
  CVE-2004-0989 to this issue.

  Yuuichi Teranishi discovered a flaw in libxml versions prior to 2.6.6.
  When fetching a remote resource via FTP or HTTP, libxml uses special
  parsing routines. These routines can overflow a buffer if passed a very
  long URL. If an attacker is able to find an application using libxml that
  parses remote resources and allows them to influence the URL, then this
  flaw could be used to execute arbitrary code. The Common Vulnerabilities
  and Exposures project (cve.mitre.org) has assigned the name CVE-2004-0110
  to this issue.

  All users are advised to upgrade to this updated package, which contains
  backported patches and is not vulnerable to these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2004-650.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libxml packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libxml-1.8.14-3", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libxml-devel-1.8.14-3", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libxml-1.8.17-9.2", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libxml-devel-1.8.17-9.2", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libxml-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2004-0110", value:TRUE);
 set_kb_item(name:"CVE-2004-0989", value:TRUE);
}
if ( rpm_exists(rpm:"libxml-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2004-0110", value:TRUE);
 set_kb_item(name:"CVE-2004-0989", value:TRUE);
}

set_kb_item(name:"RHSA-2004-650", value:TRUE);
