#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23676);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5170");

 name["english"] = "RHSA-2006-0719: nss_ldap";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated nss_ldap packages that fix a security flaw are now available for
  Red Hat Enterprise Linux 4.

  This update has been rated as having moderate security impact by the Red
  Hat
  Security Response Team.

  nss_ldap is a set of C library extensions that allow X.500 and LDAP
  directory servers to be used as primary sources for aliases, ethers,
  groups, hosts, networks, protocols, users, RPCs, services, and shadow
  passwords.

  A flaw was found in the way nss_ldap handled a PasswordPolicyResponse
  control sent by an LDAP server. If an LDAP server responded to an
  authentication request with a PasswordPolicyResponse control, it was
  possible for an application using nss_ldap to improperly authenticate
  certain users. (CVE-2006-5170)

  This flaw was only exploitable within applications which did not properly
  process nss_ldap error messages. Only xscreensaver is currently known to
  exhibit this behavior.

  All users of nss_ldap should upgrade to these updated packages, which
  contain a backported patch that resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0719.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nss_ldap packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"nss_ldap-226-17", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"nss_ldap-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5170", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0719", value:TRUE);
