#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23677);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4574", "CVE-2006-4805", "CVE-2006-5468", "CVE-2006-5469", "CVE-2006-5740");

 name["english"] = "RHSA-2006-0726: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  New Wireshark packages that fix various security vulnerabilities are now
  available.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Wireshark is a program for monitoring network traffic.

  Several flaws were found in Wireshark\'s HTTP, WBXML, LDAP, and XOT protocol
  dissectors. Wireshark could crash or stop responding if it read a malformed
  packet off the network. (CVE-2006-4805, CVE-2006-5468, CVE-2006-5469,
  CVE-2006-5740)

  A single NULL byte heap based buffer overflow was found in Wireshark\'s MIME
  Multipart dissector. Wireshark could crash or possibly execute arbitrary
  arbitrary code as the user running Wireshark. (CVE-2006-4574)

  Users of Wireshark should upgrade to these updated packages containing
  Wireshark version 0.99.4, which is not vulnerable to these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0726.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"wireshark-0.99.4-AS21.1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.4-AS21.1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.4-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.4-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.4-EL4.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.4-EL4.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"wireshark-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-4574", value:TRUE);
 set_kb_item(name:"CVE-2006-4805", value:TRUE);
 set_kb_item(name:"CVE-2006-5468", value:TRUE);
 set_kb_item(name:"CVE-2006-5469", value:TRUE);
 set_kb_item(name:"CVE-2006-5740", value:TRUE);
}
if ( rpm_exists(rpm:"wireshark-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-4574", value:TRUE);
 set_kb_item(name:"CVE-2006-4805", value:TRUE);
 set_kb_item(name:"CVE-2006-5468", value:TRUE);
 set_kb_item(name:"CVE-2006-5469", value:TRUE);
 set_kb_item(name:"CVE-2006-5740", value:TRUE);
}
if ( rpm_exists(rpm:"wireshark-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4574", value:TRUE);
 set_kb_item(name:"CVE-2006-4805", value:TRUE);
 set_kb_item(name:"CVE-2006-5468", value:TRUE);
 set_kb_item(name:"CVE-2006-5469", value:TRUE);
 set_kb_item(name:"CVE-2006-5740", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0726", value:TRUE);
