#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23959);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6097");

 name["english"] = "RHSA-2006-0749: tar";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated tar packages that fix a path traversal flaw are now available.

  This update has been rated as having moderate security impact by the Red
  Hat
  Security Response Team.

  The GNU tar program saves many files together in one archive and can
  restore individual files (or all of the files) from that archive.

  Teemu Salmela discovered a path traversal flaw in the way GNU tar extracted
  archives. A malicious user could create a tar archive that could write to
  arbitrary files to which the user running GNU tar has write access.
  (CVE-2006-6097)

  Users of tar should upgrade to this updated package, which contains a
  replacement backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0749.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tar packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tar-1.13.25-6.AS21.1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.13.25-15.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.14-12.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"tar-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-6097", value:TRUE);
}
if ( rpm_exists(rpm:"tar-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-6097", value:TRUE);
}
if ( rpm_exists(rpm:"tar-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-6097", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0749", value:TRUE);
