#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24676);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6120");

 name["english"] = "RHSA-2007-0010: koffice";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated KOffice packages that fix a security issue are now available for
  Red Hat Enterprise Linux 2.1.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  KOffice is a collection of productivity applications for the K Desktop
  Environment (KDE) GUI desktop.

  An integer overflow bug was found in KOffice\'s PPT file processor. An
  attacker could create a malicious PPT file that could cause KOffice to
  execute arbitrary code if the file was opened by a victim. (CVE-2006-6120)

  All users of KOffice are advised to upgrade to these updated packages,
  which
  contains a backported patch to correct this issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0010.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the koffice packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"koffice-1.1.1-2.3", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"koffice-devel-1.1.1-2.3", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"koffice-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-6120", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0010", value:TRUE);
