#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24259);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0010");

 name["english"] = "RHSA-2007-0019: gtk";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated gtk2 packages that fix a security issue are now available.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The gtk2 package contains the GIMP ToolKit (GTK+), a library for creating
  graphical user interfaces for the X Window System.

  A bug was found in the way the gtk2 GdkPixbufLoader() function processed
  invalid input. Applications linked against gtk2 could crash if they
  loaded a malformed image file. (CVE-2007-0010)

  Users of gtk2 are advised to upgrade to these updated packages, which
  contain a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0019.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gtk packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gtk2-2.4.13-22", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gtk2-devel-2.4.13-22", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gtk-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0010", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0019", value:TRUE);
