#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24317);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6142");

 name["english"] = "RHSA-2007-0022:   squirrelmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  A new squirrelmail package that fixes security issues is now available for
  Red Hat Enterprise Linux 3 and 4.

  SquirrelMail is a standards-based webmail package written in PHP.

  Several cross-site scripting bugs were discovered in SquirrelMail. An
  attacker could inject arbitrary Javascript or HTML content into
  SquirrelMail pages by tricking a user into visiting a carefully crafted
  URL. (CVE-2006-6142)

  Users of SquirrelMail should upgrade to this erratum package, which
  contains a backported patch to correct these issues.

  Notes:
  - After installing this update, users are advised to restart their
  httpd service to ensure that the updated version functions correctly.
  - config.php should NOT be modified, please modify config_local.php
  instead.
  - Known Bug: The configuration generator may potentially produce bad
  options that interfere with the operation of this application. Applying
  specific config changes to config_local.php manually is recommended.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0022.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the   squirrelmail packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"  squirrelmail-1.4.8-4.el3.noarch.rpm      865dcb1f2136970e1a700b721cb6773f", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  squirrelmail-1.4.8-4.el4.noarch.rpm      267c1d4b63b5d0b125bf012a6e1d0410", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"  squirrelmail-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-6142", value:TRUE);
}
if ( rpm_exists(rpm:"  squirrelmail-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-6142", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0022", value:TRUE);
