#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25315);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5540", "CVE-2006-5541", "CVE-2006-5542", "CVE-2007-0555", "CVE-2007-0556");

 name["english"] = "RHSA-2007-0068: postgresql";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated postgresql packages that fix several security issues are now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  PostgreSQL is an advanced Object-Relational database management system
  (DBMS).

  Two flaws were found in the way the PostgreSQL server handles certain
  SQL-language functions. An authenticated user could execute a sequence of
  commands which could crash the PostgreSQL server or possibly read from
  arbitrary memory locations. A user would need to have permissions to drop
  and add database tables to be able to exploit these issues (CVE-2007-0555,
  CVE-2007-0556).

  Several denial of service flaws were found in the PostgreSQL server. An
  authenticated user could execute certain SQL commands which could crash the
  PostgreSQL server (CVE-2006-5540, CVE-2006-5541, CVE-2006-5542).

  Users of PostgreSQL should upgrade to these updated packages containing
  PostgreSQL version 8.1.8 which corrects these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0068.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the postgresql packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"postgresql-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-devel-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-pl-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-server-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-test-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-8.1.8-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"postgresql-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-5540", value:TRUE);
 set_kb_item(name:"CVE-2006-5541", value:TRUE);
 set_kb_item(name:"CVE-2006-5542", value:TRUE);
 set_kb_item(name:"CVE-2007-0555", value:TRUE);
 set_kb_item(name:"CVE-2007-0556", value:TRUE);
}
if ( rpm_exists(rpm:"postgresql-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-5540", value:TRUE);
 set_kb_item(name:"CVE-2006-5541", value:TRUE);
 set_kb_item(name:"CVE-2006-5542", value:TRUE);
 set_kb_item(name:"CVE-2007-0555", value:TRUE);
 set_kb_item(name:"CVE-2007-0556", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0068", value:TRUE);
