#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25317);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0906", "CVE-2007-0907", "CVE-2007-0908", "CVE-2007-0909", "CVE-2007-0910", "CVE-2007-0988", "CVE-2007-1285", "CVE-2007-1380", "CVE-2007-1701", "CVE-2007-1825");

 name["english"] = "RHSA-2007-0082: php";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated PHP packages that fix several security issues are now available for
  Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  PHP is an HTML-embedded scripting language commonly used with the Apache
  HTTP Web server.

  A number of buffer overflow flaws were found in the PHP session extension;
  the str_replace() function; and the imap_mail_compose() function. If very
  long strings were passed to the str_replace() function, an integer
  overflow could occur in memory allocation. If a script used the
  imap_mail_compose() function to create a new MIME message based on an
  input body from an untrusted source, it could result in a heap overflow.
  An attacker with access to a PHP application affected by any these issues
  could trigger the flaws and possibly execute arbitrary code as the
  \'apache\' user. (CVE-2007-0906)

  When unserializing untrusted data on 64-bit platforms, the
  zend_hash_init() function could be forced into an infinite loop, consuming
  CPU resources for a limited time, until the script timeout alarm aborted
  execution of the script. (CVE-2007-0988)

  If the wddx extension was used to import WDDX data from an untrusted
  source, certain WDDX input packets could expose a random portion of heap
  memory. (CVE-2007-0908)

  If the odbc_result_all() function was used to display data from a
  database, and the database table contents were under an attacker\'s
  control, a format string vulnerability was possible which could allow
  arbitrary code execution. (CVE-2007-0909)

  A one byte memory read always occurs before the beginning of a buffer.
  This could be triggered, for example, by any use of the header() function
  in a script. However it is unlikely that this would have any effect.
  (CVE-2007-0907)

  Several flaws in PHP could allow attackers to "clobber" certain
  super-global variables via unspecified vectors. (CVE-2007-0910)

  An input validation bug allowed a remote attacker to trigger a denial of
  service attack by submitting an input variable with a deeply-nested-array.
  (CVE-2007-1285)

  Users of PHP should upgrade to these updated packages which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0082.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"php-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-bcmath-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-cli-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-common-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-dba-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-gd-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ldap-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mbstring-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mysql-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ncurses-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-odbc-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pdo-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pgsql-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-snmp-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-soap-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-xml-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-xmlrpc-5.1.6-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"php-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0906", value:TRUE);
 set_kb_item(name:"CVE-2007-0907", value:TRUE);
 set_kb_item(name:"CVE-2007-0908", value:TRUE);
 set_kb_item(name:"CVE-2007-0909", value:TRUE);
 set_kb_item(name:"CVE-2007-0910", value:TRUE);
 set_kb_item(name:"CVE-2007-0988", value:TRUE);
 set_kb_item(name:"CVE-2007-1285", value:TRUE);
 set_kb_item(name:"CVE-2007-1380", value:TRUE);
 set_kb_item(name:"CVE-2007-1701", value:TRUE);
 set_kb_item(name:"CVE-2007-1825", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0082", value:TRUE);
