#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24724);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0001", "CVE-2007-0006");

 name["english"] = "RHSA-2007-0085:   kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated kernel packages that fix two security issues and a bug in the Red Hat
  Enterprise Linux 4 kernel are now available.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The Linux kernel handles the basic functions of the operating system.

  These new kernel packages contain fixes for two security issues:

  * a flaw in the key serial number collision avoidance algorithm of the
  keyctl subsystem that allowed a local user to cause a denial of service
  (CVE-2007-0006, Important)

  * a flaw in the file watch implementation of the audit subsystems that
  allowed a local user to cause a denial of service (panic). To exploit this
  flaw a privileged user must have previously created a watch for a file
  (CVE-2007-0001, Moderate)

  In addition to the security issues described above, a fix for the SCTP
  subsystem to address a system crash which may be experienced in Telco
  environments has been included.

  Red Hat Enterprise Linux 4 users are advised to upgrade their kernels to
  the packages associated with their machine architecture and configurations
  as listed in this erratum.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0085.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the   kernel packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"  kernel-2.6.9-42.0.10.EL.i686.rpm                       7b18d06a3323f40304e6d2220b814cc9", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-devel-2.6.9-42.0.10.EL.i686.rpm                 9fa98cea9b4347f1bb934c955e12777c", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-doc-2.6.9-42.0.10.EL.noarch.rpm                 183fe23ac5e8be41adf6c05d81b76555", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-hugemem-2.6.9-42.0.10.EL.i686.rpm               abea2f5ae09397381300f476e1c851d3", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-hugemem-devel-2.6.9-42.0.10.EL.i686.rpm         059ef62c55b663de5cf3493f68edb61a", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-smp-2.6.9-42.0.10.EL.i686.rpm                   a6b7c14dd615c2ba596218f99d6dc791", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-smp-devel-2.6.9-42.0.10.EL.i686.rpm             4eef61b5cafa9decc595a7ad8777dce0", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"  kernel-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0001", value:TRUE);
 set_kb_item(name:"CVE-2007-0006", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0085", value:TRUE);
