#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24678);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1007");

 name["english"] = "RHSA-2007-0086: gnomemeeting";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated gnomemeeting packages that fix a security issue are now available
  for Red Hat Enterprise Linux.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  GnomeMeeting is a tool to communicate with video and audio over the
  Internet.

  A format string flaw was found in the way GnomeMeeting processes certain
  messages. If a user is running GnomeMeeting, a remote attacker who can
  connect to GnomeMeeting could trigger this flaw and potentially execute
  arbitrary code with the privileges of the user. (CVE-2007-1007)

  Users of GnomeMeeting should upgrade to these updated packages which
  contain a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0086.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnomemeeting packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gnomemeeting-0.96.0-5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnomemeeting-1.0.2-9", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gnomemeeting-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1007", value:TRUE);
}
if ( rpm_exists(rpm:"gnomemeeting-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1007", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0086", value:TRUE);
