#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25319);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0005", "CVE-2007-0006", "CVE-2007-0958");

 name["english"] = "RHSA-2007-0099: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated kernel packages that fix security issues and bugs in the Red Hat
  Enterprise Linux 5 kernel are now available.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The Linux kernel handles the basic functions of the operating system.

  These new kernel packages contain fixes for the following security issues:

  * a flaw in the key serial number collision avoidance algorithm of the
  keyctl subsystem that allowed a local user to cause a denial of service
  (CVE-2007-0006, Important)

  * a flaw in the Omnikey CardMan 4040 driver that allowed a local user to
  execute arbitrary code with kernel privileges. In order to exploit this
  issue, the Omnikey CardMan 4040 PCMCIA card must be present and the local
  user must have access rights to the character device created by the driver.
  (CVE-2007-0005, Moderate)

  * a flaw in the core-dump handling that allowed a local user to create core
  dumps from unreadable binaries via PT_INTERP. (CVE-2007-0958, Low)

  In addition to the security issues described above, a fix for a kernel
  panic in the powernow-k8 module, and a fix for a kernel panic when booting
  the Xen domain-0 on system with large memory installations have been included.

  Red Hat would like to thank Daniel Roethlisberger for reporting an issue
  fixed in this erratum.

  Red Hat Enterprise Linux 5 users are advised to upgrade their kernels to
  the packages associated with their machine architecture and configurations
  as listed in this erratum.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0099.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kernel-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-PAE-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-PAE-devel-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-devel-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-doc-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-headers-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-xen-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-xen-devel-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-PAE-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-doc-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-headers-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-xen-2.6.18-8.1.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"kernel-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0005", value:TRUE);
 set_kb_item(name:"CVE-2007-0006", value:TRUE);
 set_kb_item(name:"CVE-2007-0958", value:TRUE);
}
if ( rpm_exists(rpm:"kernel-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0005", value:TRUE);
 set_kb_item(name:"CVE-2007-0006", value:TRUE);
 set_kb_item(name:"CVE-2007-0958", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0099", value:TRUE);
