#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24775);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1263");

 name["english"] = "RHSA-2007-0106: gnupg";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated GnuPG packages that fix a security issue are now available.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  GnuPG is a utility for encrypting data and creating digital signatures.

  Gerardo Richarte discovered that a number of applications that make use of
  GnuPG are prone to a vulnerability involving incorrect verification of
  signatures and encryption. An attacker could add arbitrary content to a
  signed message in such a way that a receiver of the message would not be
  able to distinguish between the properly signed parts of a message and the
  forged, unsigned, parts. (CVE-2007-1263)

  Whilst this is not a vulnerability in GnuPG itself, the GnuPG team have
  produced a patch to protect against messages with multiple plaintext
  packets. Users should update to these erratum packages which contain the
  backported patch for this issue.

  Red Hat would like to thank Core Security Technologies for reporting this
  issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0106.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gnupg-1.0.7-21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.2.1-20", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.2.6-9", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gnupg-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1263", value:TRUE);
}
if ( rpm_exists(rpm:"gnupg-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1263", value:TRUE);
}
if ( rpm_exists(rpm:"gnupg-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1263", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0106", value:TRUE);
