#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25324);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1351", "CVE-2007-1352");

 name["english"] = "RHSA-2007-0132: libXfont";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated X.org libXfont packages that fix a security issue are now available
  for Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  X.org is an open source implementation of the X Window System. It provides
  the basic low-level functionality that full-fledged graphical user
  interfaces are designed upon.

  iDefense reported two integer overflows in the way X.org handled various
  font files. A malicious local user could exploit these issues to
  potentially execute arbitrary code with the privileges of the X.org server.
  (CVE-2007-1351, CVE-2007-1352)

  Users of X.org libXfont should upgrade to these updated packages, which
  contain a backported patch and are not vulnerable to this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0132.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libXfont packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libXfont-1.2.2-1.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libXfont-devel-1.2.2-1.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libXfont-1.2.2-1.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libXfont-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1351", value:TRUE);
 set_kb_item(name:"CVE-2007-1352", value:TRUE);
}
if ( rpm_exists(rpm:"libXfont-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1351", value:TRUE);
 set_kb_item(name:"CVE-2007-1352", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0132", value:TRUE);
