#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25067);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1285", "CVE-2007-1286", "CVE-2007-1711");

 name["english"] = "RHSA-2007-0154: php";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated PHP packages that fix several security issues are now available for
  Red Hat Enterprise Linux 2.1.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  PHP is an HTML-embedded scripting language commonly used with the Apache
  HTTP Web server.

  A denial of service flaw was found in the way PHP processed a deeply nested
  array. A remote attacker could cause the PHP interpreter to crash by
  submitting an input variable with a deeply nested array. (CVE-2007-1285)

  A flaw was found in the way PHP\'s unserialize() function processes data. If
  a remote attacker is able to pass arbitrary data to PHP\'s unserialize()
  function, it may be possible for them to execute arbitrary code as the
  apache user. (CVE-2007-1286)

  A double free flaw was found in PHP\'s session_decode() function. If a
  remote attacker is able to pass arbitrary data to PHP\'s session_decode()
  function, it may be possible for them to execute arbitrary code as the
  apache user. (CVE-2007-1711)

  Users of PHP should upgrade to these updated packages which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0154.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"php-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ldap-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-manual-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mysql-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-odbc-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pgsql-4.1.2-2.17", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"php-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1285", value:TRUE);
 set_kb_item(name:"CVE-2007-1286", value:TRUE);
 set_kb_item(name:"CVE-2007-1711", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0154", value:TRUE);
