#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25068);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0455", "CVE-2007-1001", "CVE-2007-1285", "CVE-2007-1286", "CVE-2007-1583", "CVE-2007-1711", "CVE-2007-1718");

 name["english"] = "RHSA-2007-0155: php";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated PHP packages that fix several security issues are now available for
  Red Hat Enterprise Linux 3 and 4.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  PHP is an HTML-embedded scripting language commonly used with the Apache
  HTTP Web server.

  A denial of service flaw was found in the way PHP processed a deeply nested
  array. A remote attacker could cause the PHP interpreter to crash by
  submitting an input variable with a deeply nested array. (CVE-2007-1285)

  A flaw was found in the way PHP\'s unserialize() function processed data. If
  a remote attacker was able to pass arbitrary data to PHP\'s unserialize()
  function, they could possibly execute arbitrary code as the apache user.
  (CVE-2007-1286)

  A flaw was found in the way the mbstring extension set global variables. A
  script which used the mb_parse_str() function to set global variables could
  be forced to enable the register_globals configuration option, possibly
  resulting in global variable injection. (CVE-2007-1583)

  A double free flaw was found in PHP\'s session_decode() function. If a
  remote attacker was able to pass arbitrary data to PHP\'s session_decode()
  function, they could possibly execute arbitrary code as the apache user.
  (CVE-2007-1711)

  A flaw was discovered in the way PHP\'s mail() function processed header
  data. If a script sent mail using a Subject header containing a string from
  an untrusted source, a remote attacker could send bulk e-mail to unintended
  recipients. (CVE-2007-1718)

  A heap based buffer overflow flaw was discovered in PHP\'s gd extension. A
  script that could be forced to process WBMP images from an untrusted source
  could result in arbitrary code execution. (CVE-2007-1001)

  A buffer over-read flaw was discovered in PHP\'s gd extension. A script that
  could be forced to write arbitrary string using a JIS font from an
  untrusted source could cause the PHP interpreter to crash. (CVE-2007-0455)

  Users of PHP should upgrade to these updated packages which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0155.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"php-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ldap-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mysql-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-odbc-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pgsql-4.3.2-40.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-domxml-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-gd-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ldap-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mbstring-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mysql-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ncurses-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-odbc-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pear-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pgsql-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-snmp-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-xmlrpc-4.3.9-3.22.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"php-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-1001", value:TRUE);
 set_kb_item(name:"CVE-2007-1285", value:TRUE);
 set_kb_item(name:"CVE-2007-1286", value:TRUE);
 set_kb_item(name:"CVE-2007-1583", value:TRUE);
 set_kb_item(name:"CVE-2007-1711", value:TRUE);
 set_kb_item(name:"CVE-2007-1718", value:TRUE);
}
if ( rpm_exists(rpm:"php-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-1001", value:TRUE);
 set_kb_item(name:"CVE-2007-1285", value:TRUE);
 set_kb_item(name:"CVE-2007-1286", value:TRUE);
 set_kb_item(name:"CVE-2007-1583", value:TRUE);
 set_kb_item(name:"CVE-2007-1711", value:TRUE);
 set_kb_item(name:"CVE-2007-1718", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0155", value:TRUE);
