#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25326);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1667");

 name["english"] = "RHSA-2007-0157: libX";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated xorg-x11-apps and libX11 packages that fix a security issue are now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  X.org is an open source implementation of the X Window System. It provides
  the basic low-level functionality that full-fledged graphical user
  interfaces are designed upon.

  An integer overflow flaw was found in the X.org XGetPixel() function.
  Improper use of this function could cause an application calling it to
  function improperly, possibly leading to a crash or arbitrary code
  execution. (CVE-2007-1667)

  Users of the X.org X11 server should upgrade to these updated packages,
  which contain a backported patch and are not vulnerable to this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0157.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libX packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libX11-1.0.3-8.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libX11-devel-1.0.3-8.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-apps-7.1-4.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libX11-1.0.3-8.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-apps-7.1-4.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libX-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1667", value:TRUE);
}
if ( rpm_exists(rpm:"libX-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1667", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0157", value:TRUE);
