#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25142);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-7176");

 name["english"] = "RHSA-2007-0252: sendmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated sendmail packages that fix a security issue and various bugs are now
  available for Red Hat Enterprise Linux 4.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  Sendmail is a very widely used Mail Transport Agent (MTA). MTAs deliver
  mail from one machine to another. Sendmail is not a client program, but
  rather a behind-the-scenes daemon that moves email over networks or the
  Internet to its final destination.

  The configuration of Sendmail on Red Hat Enterprise Linux was found to not
  reject the "localhost.localdomain" domain name for e-mail messages that
  came from external hosts. This could have allowed remote attackers to
  disguise spoofed messages (CVE-2006-7176).

  This updated package also fixes the following bugs:

  * Infinite loop within tls read.

  * Incorrect path to selinuxenabled in initscript.

  * Build artifacts from sendmail-cf package.

  * Missing socketmap support.

  * Add support for CipherList configuration directive.

  * Path for aliases file.

  * Failure of shutting down sm-client.

  * Allows to specify persistent queue runners.

  * Missing dnl for SMART_HOST define.

  * Fixes connections stay in CLOSE_WAIT.

  All users of Sendmail should upgrade to these updated packages, which
  contains backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0252.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sendmail packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"sendmail-8.13.1-3.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"sendmail-cf-8.13.1-3.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"sendmail-devel-8.13.1-3.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"sendmail-doc-8.13.1-3.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"sendmail-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-7176", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0252", value:TRUE);
