#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25145);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-1057");

 name["english"] = "RHSA-2007-0286: gdm";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated gdm package that fixes a security issue and a bug is now
  available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  Gdm (the GNOME Display Manager) is a highly configurable reimplementation
  of xdm, the X Display Manager. Gdm allows you to log into your system with
  the X Window System running and supports running several different X
  sessions on your local machine at the same time.

  Marcus Meissner discovered a race condition issue in the way Gdm modifies
  the permissions on the .ICEauthority file. A local attacker could exploit
  this flaw to gain privileges. Due to the nature of the flaw, however, a
  successful exploitation was unlikely. (CVE-2006-1057)

  This erratum also includes a bug fix to correct the pam configuration for
  the audit system.

  All users of gdm should upgrade to this updated package, which contains
  backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0286.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gdm packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gdm-2.6.0.5-7.rhel4.15", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gdm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-1057", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0286", value:TRUE);
