#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25331);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2356");

 name["english"] = "RHSA-2007-0343: gimp";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated gimp packages that fix a security issue are now available for Red
  Hat Enterprise Linux.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The GIMP (GNU Image Manipulation Program) is an image composition and
  editing program.

  Marsu discovered a stack overflow bug in The GIMP RAS file loader. An
  attacker could create a carefully crafted file that could cause The GIMP to
  crash or possibly execute arbitrary code if the file was opened by a
  victim. (CVE-2007-2356)

  For users of Red Hat Enterprise Linux 5, the previous GIMP packages had a
  bug that concerned the execution order in which the symbolic links to
  externally packaged GIMP plugins are installed and removed, causing the
  symbolic links to vanish when the package is updated.

  Users of The GIMP should update to these erratum packages which contain a
  backported fix to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0343.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gimp packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gimp-2.2.13-2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.2.13-2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-libs-2.2.13-2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.3-20.3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.3-20.3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.3-20.3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.0.5-6.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.0.5-6.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.2.13-2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-libs-2.2.13-2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.0.5-6.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.0.5-6.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.1-7.1.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.0.5-6.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.0.5-6.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gimp-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2356", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0343", value:TRUE);
