#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25332);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2438");

 name["english"] = "RHSA-2007-0346: vim";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated vim packages that fix a security issue are now available for Red
  Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red Hat
  Security Response Team.

  VIM (VIsual editor iMproved) is a version of the vi editor.

  An arbitrary command execution flaw was found in the way VIM processes
  modelines. If a user with modelines enabled opened a text file containing
  a carefully crafted modeline, arbitrary commands could be executed as the
  user
  running VIM. (CVE-2007-2438)

  Users of VIM are advised to upgrade to these updated packages, which
  resolve this issue.

  Please note: this issue did not affect VIM as distributed with Red Hat
  Enterprise Linux 2.1, 3, or 4.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0346.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the vim packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"vim-X11-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-common-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-enhanced-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-minimal-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-X11-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-common-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-enhanced-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vim-minimal-7.0.109-3.el5.3", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"vim-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2438", value:TRUE);
}
if ( rpm_exists(rpm:"vim-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2438", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0346", value:TRUE);
