#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25268);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1558");

 name["english"] = "RHSA-2007-0353: evolution";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated evolution packages that fix a security bug are now available for
  Red Hat Enterprise Linux 3 and 4.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Evolution is the GNOME collection of personal information management (PIM)
  tools.

  A flaw was found in the way Evolution processed certain APOP authentication
  requests. A remote attacker could potentially acquire certain portions of a
  user\'s authentication credentials by sending certain responses when
  evolution-data-server attempted to authenticate against an APOP server.
  (CVE-2007-1558)

  All users of Evolution should upgrade to these updated packages, which
  contain a backported patch which resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0353.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evolution packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"evolution-1.4.5-20.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-devel-1.4.5-20.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-2.0.2-35.0.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-devel-2.0.2-35.0.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"evolution-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"evolution-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0353", value:TRUE);
