#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25604);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2442", "CVE-2007-2443", "CVE-2007-2798");

 name["english"] = "RHSA-2007-0384: krb";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated krb5 packages that fix several security flaws are now available for
  Red Hat Enterprise Linux 2.1 and 3.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  Kerberos is a network authentication system which allows clients and
  servers to authenticate to each other through use of symmetric encryption
  and a trusted third party, the KDC. kadmind is the KADM5 administration
  server.

  David Coffey discovered an uninitialized pointer free flaw in the RPC
  library used by kadmind. A remote unauthenticated attacker who can access
  kadmind could trigger this flaw and cause kadmind to crash or potentially
  execute arbitrary code as root. (CVE-2007-2442)

  David Coffey also discovered an overflow flaw in the RPC library used by
  kadmind. On Red Hat Enterprise Linux, exploitation of this flaw is limited
  to a denial of service. A remote unauthenticated attacker who can access
  kadmind could trigger this flaw and cause kadmind to crash. (CVE-2007-2443)

  A stack buffer overflow flaw was found in kadmind. An authenticated
  attacker who can access kadmind could trigger this flaw and potentially
  execute arbitrary code on the Kerberos server. (CVE-2007-2798)

  For Red Hat Enterprise Linux 2.1, several portability bugs which would lead
  to unexpected crashes on the ia64 platform have also been fixed.

  Users of krb5-server are advised to update to these erratum packages which
  contain backported fixes to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0384.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"krb5-devel-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-devel-1.2.7-66", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.2.7-66", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.2.7-66", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.2.7-66", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-devel-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-devel-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.2.2-47", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"krb-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2442", value:TRUE);
 set_kb_item(name:"CVE-2007-2443", value:TRUE);
 set_kb_item(name:"CVE-2007-2798", value:TRUE);
}
if ( rpm_exists(rpm:"krb-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2442", value:TRUE);
 set_kb_item(name:"CVE-2007-2443", value:TRUE);
 set_kb_item(name:"CVE-2007-2798", value:TRUE);
}
if ( rpm_exists(rpm:"krb-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2442", value:TRUE);
 set_kb_item(name:"CVE-2007-2443", value:TRUE);
 set_kb_item(name:"CVE-2007-2798", value:TRUE);
}
if ( rpm_exists(rpm:"krb-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2442", value:TRUE);
 set_kb_item(name:"CVE-2007-2443", value:TRUE);
 set_kb_item(name:"CVE-2007-2798", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0384", value:TRUE);
